package mirrg.simulation.cart.almandine.mods.vanilla.furnitures;

import java.awt.Point;

import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.ManagerEnvironment;

public class FurnitureSupplier extends FurnitureIO
{

	@Deprecated
	public FurnitureSupplier()
	{
		super();
	}

	public FurnitureSupplier(GameAlmandine game, Point point, double duration) throws IllegalEntityIdException
	{
		super(game, point, duration);
	}

	@Override
	protected int getBackColor()
	{
		return 0x80a080;
	}

	@Override
	public void tick(double deltaSecond) throws IllegalEntityIdException
	{
		super.tick(deltaSecond);

		gauge.amount += deltaSecond;
		if (gauge.amount >= gauge.capacity) {
			if (slot.slot.tryPush(ManagerEnvironment.createStackSlab(game, getPoint(), 1, slot.slot)) == 1) {
				gauge.amount = 0;
			} else {
				gauge.amount = gauge.capacity;
			}
		}

	}

}
