package mirrg.simulation.cart.almandine.mods.vanilla.parts;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;

import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.facroty.property.IDialogProperty;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.factory.Part;

public abstract class PartRectangleBase extends Part
{

	@Deprecated
	public PartRectangleBase()
	{
		super();
	}

	public PartRectangleBase(GameAlmandine game, Bound bound)
	{
		super(game);
		this.bound = bound;
	}

	public Bound bound;

	public boolean isContained(Rectangle rectangle) throws IllegalEntityIdException
	{
		return bound.contained(rectangle);
	}

	@Override
	public boolean isHover(int x, int y)
	{
		return bound.contains(x, y);
	}

	public void move(int dx, int dy)
	{
		bound = bound.translate(dx, dy);
	}

	@Override
	public void drawHover(Graphics2D graphics)
	{

		graphics.setColor(new Color(0x7bfc82));

		Stroke stroke = graphics.getStroke();
		graphics.setStroke(new BasicStroke(3.0f));

		graphics.draw(bound.grow(5).createShape());

		graphics.setStroke(stroke);

	}

	@Override
	protected void addProperty(IDialogProperty dialogProperty)
	{
		super.addProperty(dialogProperty);

		dialogProperty.addPropertyInt("X", "px", () -> bound.getX(), x -> {
			bound = new Bound(x, bound.getY(), bound.getWidth(), bound.getHeight());
			return true;
		});
		dialogProperty.addPropertyInt("Y", "px", () -> bound.getY(), y -> {
			bound = new Bound(bound.getX(), y, bound.getWidth(), bound.getHeight());
			return true;
		});
		dialogProperty.addPropertyInt("Width", "px", () -> bound.getWidth(), width -> {
			bound = new Bound(bound.getX(), bound.getY(), width, bound.getHeight());
			return true;
		});
		dialogProperty.addPropertyInt("Height", "px", () -> bound.getHeight(), height -> {
			bound = new Bound(bound.getX(), bound.getY(), bound.getWidth(), height);
			return true;
		});
	}

	@Override
	public Point getPoint() throws IllegalEntityIdException
	{
		return bound.getCenter();
	}

}
