package mirrg.simulation.cart.almandine.mods.vanilla.primaries;

import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.facroty.property.IDialogProperty;
import mirrg.simulation.cart.almandine.mods.vanilla.ProviderEnvironmentThermoModifier;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.Bound;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.Environment;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.IProviderEnvironment;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.IStackSlab;

public class AreaEnvironmentThermo extends AreaBase implements IProviderEnvironment
{

	public ProviderEnvironmentThermoModifier providerEnvironment;

	@Deprecated
	public AreaEnvironmentThermo()
	{
		super();
	}

	public AreaEnvironmentThermo(GameAlmandine game, Bound bound)
	{
		super(game, bound);
		providerEnvironment = new ProviderEnvironmentThermoModifier();
	}

	@Override
	protected void addProperty(IDialogProperty dialogProperty)
	{
		super.addProperty(dialogProperty);
		providerEnvironment.addProperty(dialogProperty);
	}

	@Override
	public void getEnvironment(Environment environment)
	{
		providerEnvironment.getEnvironment(environment);
	}

	@Override
	public IStackSlab createStackSlab(int amount, Environment environment)
	{
		return providerEnvironment.createStackSlab(amount, environment);
	}

	@Override
	protected int getColor()
	{
		return 0xc986cc;
	}

}
