package mirrg.simulation.cart.almandine.mods.vanilla.primaries;

import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.facroty.property.IDialogProperty;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.Bound;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.Environment;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.IProviderEnvironment;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.IStackSlab;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.RegistryProviderEnvironment;

public class AreaProviderEnvironment extends AreaBase implements IProviderEnvironment
{

	public String idProviderEnvironment;
	public boolean enabledGetEnvironment;
	public boolean enabledCreateStackSlab;

	@Deprecated
	public AreaProviderEnvironment()
	{
		super();
	}

	public AreaProviderEnvironment(GameAlmandine game, Bound bound)
	{
		super(game, bound);
		enabledGetEnvironment = true;
		enabledCreateStackSlab = true;
	}

	@Override
	protected void addProperty(IDialogProperty dialogProperty)
	{
		super.addProperty(dialogProperty);
		dialogProperty.addPropertyComboBox("IdProviderEnvironment",
			RegistryProviderEnvironment.instance.getKeys().stream(),
			() -> idProviderEnvironment,
			idProviderEnvironment -> {
				this.idProviderEnvironment = idProviderEnvironment;
				return true;
			});
		dialogProperty.addPropertyBoolean("EnabledGetEnvironment", () -> enabledGetEnvironment, enabledGetEnvironment -> {
			this.enabledGetEnvironment = enabledGetEnvironment;
			return true;
		});
		dialogProperty.addPropertyBoolean("EnabledCreateStackSlab", () -> enabledCreateStackSlab, enabledCreateStackSlab -> {
			this.enabledCreateStackSlab = enabledCreateStackSlab;
			return true;
		});
	}

	@Override
	public void getEnvironment(Environment environment)
	{
		if (!enabledGetEnvironment) return;

		if (idProviderEnvironment == null) return;
		IProviderEnvironment providerEnvironment = RegistryProviderEnvironment.instance.get(idProviderEnvironment).orElse(null);
		if (providerEnvironment == null) return;
		providerEnvironment.getEnvironment(environment);
	}

	@Override
	public IStackSlab createStackSlab(int amount, Environment environment)
	{
		if (!enabledCreateStackSlab) return null;

		if (idProviderEnvironment == null) return null;
		IProviderEnvironment providerEnvironment = RegistryProviderEnvironment.instance.get(idProviderEnvironment).orElse(null);
		if (providerEnvironment == null) return null;
		return providerEnvironment.createStackSlab(amount, environment);
	}

	@Override
	protected int getColor()
	{
		return 0x92bfdd;
	}

}
