package mirrg.simulation.cart.almandine.mods.vanilla.primaries;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Optional;

import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.facroty.property.IDialogProperty;
import mirrg.simulation.cart.almandine.factory.Entity;
import mirrg.simulation.cart.almandine.factory.Factory;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.factory.Primary;
import mirrg.simulation.cart.almandine.mods.vanilla.enchant.EnchantCart;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.StationBase;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.Environment;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.IProviderEnvironment;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.ManagerEnvironment;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.SlotSlab;

public class Cart extends Primary
{

	@Deprecated
	public Cart()
	{
		super();
	}

	public SlotSlab slot;

	public Cart(GameAlmandine game, IPosition position, int capacity, double speed) throws IllegalEntityIdException
	{
		super(game);
		this.position = position;
		slot = new SlotSlab(capacity);
		this.speed = speed;
	}

	public IPosition position;

	/**
	 * [m/s]
	 */
	public double speed;

	public ArrayList<EnchantCart> enchants = new ArrayList<>();

	@Override
	public void draw(Graphics2D graphics) throws IllegalEntityIdException
	{
		Point point = getPoint();
		double angle = position.getAngle(game.factory);

		graphics.translate(point.x, point.y);
		graphics.rotate(angle);

		graphics.setColor(new Color(
			getEnvironment().getInteger("colorBackground").orElse(0x886644)));
		graphics.fillRect(-20, -8, 40, 16);
		graphics.setColor(new Color(0x444444));
		graphics.drawRect(-20 - 1, -8 - 1, 40 + 1, 16 + 1);

		graphics.rotate(Math.PI / 2);
		slot.render(graphics, new Rectangle(-8 + 3, -20 + 3, 16 - 6, 40 - 6));
		graphics.rotate(-Math.PI / 2);

		graphics.rotate(-angle);
		graphics.translate(-point.x, -point.y);

	}

	@Override
	public void drawOverlay(Graphics2D graphics) throws IllegalEntityIdException
	{
		if (selected) {
			Point point = getPoint();
			int radius = 14 + 4;

			Stroke stroke = graphics.getStroke();
			graphics.setStroke(new BasicStroke(2));

			graphics.setColor(new Color(255, 128, 0));
			graphics.draw(new Ellipse2D.Double(point.x - radius, point.y - radius, radius * 2, radius * 2));

			graphics.setStroke(stroke);
		}
	}

	@Override
	public void drawHover(Graphics2D graphics) throws IllegalEntityIdException
	{
		Point point = getPoint();
		int radius = 14 + 4;

		Stroke stroke = graphics.getStroke();
		graphics.setStroke(new BasicStroke(2));

		graphics.setColor(new Color(0x7bfc82));
		graphics.draw(new Ellipse2D.Double(point.x - radius, point.y - radius, radius * 2, radius * 2));

		graphics.setStroke(stroke);
	}

	@Override
	public boolean isContained(Rectangle rectangle) throws IllegalEntityIdException
	{
		return rectangle.contains(getPoint());
	}

	@Override
	public boolean isHover(int x, int y) throws IllegalEntityIdException
	{
		return getPoint().distanceSq(x, y) < 14 * 14;
	}

	@Override
	public void tick(double deltaSecond) throws IllegalEntityIdException
	{
		if (position instanceof PositionRail) {
			PositionRail positionRail = ((PositionRail) position);
			double deltaX = speed * deltaSecond;
			RailBase rail = positionRail.getRail(game.factory);
			double deltaRate = deltaX / rail.getDistance();

			positionRail.position += deltaRate * (positionRail.direction ? 1 : -1);

			if (positionRail.position <= 0) {
				StationBase stationBase = rail.getEntity(rail.idBegin);

				position = new PositionStation(stationBase.getId(), stationBase.freeOrder(), rail.getId());
			} else if (positionRail.position >= 1) {
				StationBase station = rail.getEntity(rail.idEnd);

				position = new PositionStation(station.getId(), station.freeOrder(), rail.getId());
			}
		}

		if (slot.stack != null) {
			slot.stack.tick(game.factory, deltaSecond, getEnvironment());
		}

	}

	public Environment getEnvironment() throws IllegalEntityIdException
	{
		Environment environment = ManagerEnvironment.getEnvironment(game, getPoint());

		enchants.forEach(enchant -> {
			if (enchant instanceof IProviderEnvironment) {
				((IProviderEnvironment) enchant).getEnvironment(environment);
			}
		});

		return environment;
	}

	public static interface IPosition
	{

		public Point2D.Double getPoint(Factory factory) throws IllegalEntityIdException;

		/**
		 * [rad]
		 */
		public double getAngle(Factory factory) throws IllegalEntityIdException;

	}

	public static class PositionStation implements IPosition
	{

		public int idStation;

		/**
		 * 0: 駅で積み下ろしなどをしている。
		 * 1～: 大きいほど列の後ろに居る。
		 */
		public int order;

		public int idRailFrom;

		public PositionStation()
		{

		}

		public PositionStation(int idStation, int order)
		{
			this(idStation, order, -1);
		}

		public PositionStation(int idStation, int order, int idRailFrom)
		{
			this.idStation = idStation;
			this.order = order;
			this.idRailFrom = idRailFrom;
		}

		@Override
		public Point2D.Double getPoint(Factory factory) throws IllegalEntityIdException
		{
			StationBase station = getStation(factory);
			Point point = station.getPoint();
			point.translate(0, station.radius + 2);
			point.translate(0, 20 * order);
			return new Point2D.Double(point.x, point.y);
		}

		@Override
		public double getAngle(Factory factory) throws IllegalEntityIdException
		{
			return 0;
		}

		public StationBase getStation(Factory factory) throws IllegalEntityIdException
		{
			return factory.getEntityOrThrow(idStation, StationBase.class);
		}

		public Optional<RailBase> getRailFrom(Factory factory)
		{
			Entity entity = factory.getEntity(idRailFrom).orElse(null);
			if (entity == null) return Optional.empty();
			if (!(entity instanceof RailBase)) return Optional.empty();

			return Optional.of((RailBase) entity);
		}

	}

	public static class PositionRail implements IPosition
	{

		public int idRail;

		/**
		 * 0～1
		 */
		public double position;

		/**
		 * true: 上り（positionが増える）
		 */
		public boolean direction;

		public PositionRail()
		{

		}

		public PositionRail(int idRail, double position, boolean direction)
		{
			this.idRail = idRail;
			this.position = position;
			this.direction = direction;
		}

		@Override
		public Point2D.Double getPoint(Factory factory) throws IllegalEntityIdException
		{
			return getRail(factory).getPoint(position);
		}

		@Override
		public double getAngle(Factory factory) throws IllegalEntityIdException
		{
			return getRail(factory).getAngle();
		}

		public RailBase getRail(Factory factory) throws IllegalEntityIdException
		{
			return factory.getEntityOrThrow(idRail, RailBase.class);
		}

	}

	@Override
	public Point getPoint() throws IllegalEntityIdException
	{
		Point2D.Double point = position.getPoint(game.factory);
		return new Point((int) point.x, (int) point.y);
	}

	@Override
	protected void addProperty(IDialogProperty dialogProperty)
	{
		super.addProperty(dialogProperty);

		slot.addProperty(game.factory, dialogProperty);
		dialogProperty.addPropertyDouble("Speed", "m/s", () -> speed, speed -> {
			if (speed < 0) return false;
			this.speed = speed;
			return true;
		});

		//

		dialogProperty.addPropertyInt("IdRail (Rail)", "id", () -> {
			if (position instanceof PositionRail) {
				return ((PositionRail) position).idRail;
			} else {
				return -1;
			}
		}, idRail -> {
			if (position instanceof PositionRail) {

				if (!game.factory.getEntity(idRail, RailBase.class).isPresent()) return false;

				((PositionRail) this.position).idRail = idRail;
				return true;

			} else {
				return false;
			}
		});
		dialogProperty.addPropertyDouble("Position (Rail)", "ratio", () -> {
			if (position instanceof PositionRail) {
				return ((PositionRail) position).position;
			} else {
				return -1;
			}
		}, position -> {
			if (this.position instanceof PositionRail) {
				if (position < 0) return false;
				if (position > 1) return false;
				((PositionRail) this.position).position = position;
				return true;
			} else {
				return false;
			}
		});
		dialogProperty.addPropertyBoolean("Direction == POSITIVE (Rail)", () -> {
			if (position instanceof PositionRail) {
				return ((PositionRail) position).direction;
			} else {
				return false;
			}
		}, direction -> {
			if (this.position instanceof PositionRail) {
				((PositionRail) this.position).direction = direction;
				return true;
			} else {
				return false;
			}
		});

		//

		dialogProperty.addPropertyInt("IdStation (Station)", "id", () -> {
			if (position instanceof PositionStation) {
				return ((PositionStation) position).idStation;
			} else {
				return -1;
			}
		}, idStation -> {
			if (position instanceof PositionStation) {

				if (!game.factory.getEntity(idStation, StationBase.class).isPresent()) return false;

				((PositionStation) this.position).idStation = idStation;
				return true;

			} else {
				return false;
			}
		});
		dialogProperty.addPropertyInt("Order (Station)", "int:0~", () -> {
			if (position instanceof PositionStation) {
				return ((PositionStation) position).order;
			} else {
				return -1;
			}
		}, order -> {
			if (this.position instanceof PositionStation) {
				((PositionStation) this.position).order = order;
				return true;
			} else {
				return false;
			}
		});
		dialogProperty.addPropertyInt("IdRailFrom (Station)", "id", () -> {
			if (position instanceof PositionStation) {
				return ((PositionStation) position).idRailFrom;
			} else {
				return -1;
			}
		}, idRailFrom -> {
			if (position instanceof PositionStation) {

				if (!game.factory.getEntity(idRailFrom, RailBase.class).isPresent()) return false;

				((PositionStation) this.position).idRailFrom = idRailFrom;
				return true;

			} else {
				return false;
			}
		});

		//

		enchants.forEach(enchant -> enchant.addProperty(dialogProperty));

	}

}
