package mirrg.simulation.cart.almandine.mods.vanilla.stackslab;

import java.awt.Point;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.factory.Factory;
import mirrg.swing.helium.property.PropertyString;

public class ManagerEnvironment
{

	public static IStackSlab createStackSlab(GameAlmandine game, Point point, int amount, SlotSlab slotSlab)
	{
		Environment environment = getEnvironment(game, point);
		Stream<IProviderEnvironment> stream = getProviderEnvironments(game, point);

		return stream
			.map(providerEnvironment -> providerEnvironment.createStackSlab(amount, environment))
			.filter(stackSlab -> stackSlab != null)
			.findFirst()
			.get();
	}

	public static IProviderEnvironment getEnvironmentDefault(GameAlmandine game)
	{
		try {
			String id = ((PropertyString) game.managerProperty.getProperty("stackslab.providerEnvironmentDefault").get()).value;
			return RegistryProviderEnvironment.instance.get(id).get();
		} catch (NoSuchElementException | ClassCastException e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * Zオーダー的に手前にある物が最初の方に格納されている配列を返す。
	 * 必ず最後に背景の1つを含む。
	 */
	public static Stream<IProviderEnvironment> getProviderEnvironments(GameAlmandine game, Point point)
	{
		return Stream.of(Factory.filterHover(game.factory.getEntities(), point).stream()
			.filter(entity -> entity instanceof IProviderEnvironment)
			.map(entity -> (IProviderEnvironment) entity),
			Stream.of(getEnvironmentDefault(game)))
			.flatMap(stream -> stream);
	}

	public static Environment getEnvironment(GameAlmandine game, Point point)
	{
		return getEnvironment(game, point, null);
	}

	/**
	 * @param providerEnvironment
	 *            nullable
	 */
	public static Environment getEnvironment(GameAlmandine game, Point point, IProviderEnvironment providerEnvironment)
	{
		Environment environment = new Environment();

		{
			ArrayList<IProviderEnvironment> providerEnvironments = getProviderEnvironments(game, point)
				.collect(Collectors.toCollection(ArrayList::new));

			for (int i = providerEnvironments.size() - 1; i >= 0; i--) {
				providerEnvironments.get(i).getEnvironment(environment);
			}
		}

		if (providerEnvironment != null) {
			providerEnvironment.getEnvironment(environment);
		}

		return environment;
	}

}
