package mirrg.simulation.cart.almandine.mods.vanilla.stackslab;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;

import mirrg.simulation.cart.almandine.facroty.property.IDialogProperty;
import mirrg.simulation.cart.almandine.factory.Factory;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;

public class SlotSlab
{

	/**
	 * nullable
	 */
	public IStackSlab stack;
	public int capacity;

	@Deprecated
	public SlotSlab()
	{

	}

	public SlotSlab(int capacity) throws IllegalEntityIdException
	{
		this.capacity = capacity;
	}

	/**
	 * nullable
	 *
	 * @see IStackSlab#tryPop(int)
	 */
	public IStackSlab tryPop(int amount)
	{
		if (stack == null) return null;
		IStackSlab stack2 = stack.tryPop(amount);
		if (stack.getAmount() == 0) stack = null;
		return stack2;
	}

	public void render(Graphics2D graphics, Rectangle bound)
	{

		// 枠
		graphics.setColor(new Color(0x000080));
		graphics.fill(bound);

		bound = new Rectangle(bound);
		bound.grow(-2, -2);

		// 背景
		graphics.setColor(new Color(0xc0c0c0));
		graphics.fill(bound);

		if (stack != null) stack.renderGauge(graphics, bound, capacity);

	}

	public int tryPush(SlotSlab slot)
	{
		int amount = tryPush(slot.stack);
		if (slot.stack.getAmount() == 0) slot.stack = null;
		return amount;
	}

	/**
	 * @see IStackSlab#push(IStackSlab)
	 */
	public int tryPush(IStackSlab stack)
	{

		// スロットがnullなら引数から0枚はぎ取って非nullにする
		if (this.stack == null) this.stack = stack.tryPop(0);

		// スロットの空き的な移動可能量計算
		int amount;
		if (this.stack.getAmount() + stack.getAmount() > capacity) {
			amount = capacity - this.stack.getAmount();
		} else {
			amount = stack.getAmount();
		}

		// 移動部分を剥ぎ取り
		IStackSlab stackTransfer = stack.tryPop(amount);

		// 実際にはぎ取れた量
		amount = stackTransfer.getAmount();

		// 移動部分を追加
		this.stack.push(stackTransfer);

		return amount;
	}

	public void addProperty(Factory factory, IDialogProperty dialogProperty)
	{
		if (stack != null) {
			stack.addProperty(factory, dialogProperty);
			dialogProperty.addPropertyInt("Capacity", "個", () -> capacity, capacity -> {
				if (capacity <= 0) return false;
				this.capacity = capacity;
				return true;
			});
		}
	}

	public boolean isFull()
	{
		return stack == null ? 0 >= capacity : stack.getAmount() >= capacity;
	}

	public boolean isEmpty()
	{
		return stack == null ? true : stack.getAmount() <= 0;
	}

}
