package mirrg.simulation.cart.almandine.mods.vanilla.toolcursors;

import mirrg.simulation.cart.almandine.IFrameGameAlmandine;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.SlotBase;
import mirrg.simulation.cart.almandine.mods.vanilla.primaries.Arm;
import mirrg.swing.helium.logging.HLog;

public class ToolCursorPutArm extends ToolCursorPutConnectionBase<SlotBase>
{

	public ToolCursorPutArm(IFrameGameAlmandine frameGameAlmandine)
	{
		super(frameGameAlmandine);
	}

	@Override
	public Class<SlotBase> getClassEntity()
	{
		return SlotBase.class;
	}

	@Override
	public String getLocalizedName()
	{
		return "設置：アーム";
	}

	@Override
	protected void add(SlotBase begin, SlotBase end)
	{
		try {
			getFactory().addLater(new Arm(getGame(), begin, end, 2 * 60));
		} catch (IllegalEntityIdException e) {
			HLog.processExceptionWarning(e);
		}
	}

	@Override
	public String getLocalizedDescription()
	{
		return "左ボタンで始点スロットから終点スロットまでドラッグ";
	}

}
