package mirrg.simulation.cart.almandine.mods.vanilla.toolcursors;

import mirrg.simulation.cart.almandine.IFrameGameAlmandine;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.StationBase;
import mirrg.simulation.cart.almandine.mods.vanilla.rails.Rail;

public class ToolCursorPutRail extends ToolCursorPutConnectionBase<StationBase>
{

	public ToolCursorPutRail(IFrameGameAlmandine frameGameAlmandine)
	{
		super(frameGameAlmandine);
	}

	@Override
	public Class<StationBase> getClassEntity()
	{
		return StationBase.class;
	}

	@Override
	public String getLocalizedName()
	{
		return "設置：レール";
	}

	@Override
	protected void add(StationBase begin, StationBase end)
	{
		getFactory().addLater(new Rail(getGame(), begin, end, 1000));
	}

	@Override
	public String getLocalizedDescription()
	{
		return "始点の駅から終点の駅まで左ドラッグ";
	}

}
