package mirrg.simulation.cart.almandine.mods.vanilla.toolcursors;

import mirrg.simulation.cart.almandine.IFrameGameAlmandine;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.StationBase;
import mirrg.simulation.cart.almandine.mods.vanilla.rails.RailAutoDistance;

public class ToolCursorPutRailAutoDistance extends ToolCursorPutConnectionBase<StationBase>
{

	public ToolCursorPutRailAutoDistance(IFrameGameAlmandine frameGameAlmandine)
	{
		super(frameGameAlmandine);
	}

	@Override
	public Class<StationBase> getClassEntity()
	{
		return StationBase.class;
	}

	@Override
	public String getLocalizedName()
	{
		return "設置：自動距離調整レール";
	}

	@Override
	protected void add(StationBase begin, StationBase end)
	{
		getFactory().addLater(new RailAutoDistance(getGame(), begin, end, 1));
	}

	@Override
	public String getLocalizedDescription()
	{
		return "始点の駅から終点の駅まで左ドラッグ";
	}

}
