package mirrg.simulation.cart.almandine.mods.vanilla.toolcursors;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.MouseEvent;

import javax.swing.SwingUtilities;

import mirrg.applet.nitrogen.events.NitrogenEventMouse;
import mirrg.applet.nitrogen.events.NitrogenEventMouseMotion;
import mirrg.simulation.cart.almandine.IFrameGameAlmandine;
import mirrg.simulation.cart.almandine.gui.toolcursor.NitrogenEventToolCursor;
import mirrg.simulation.cart.almandine.gui.toolcursor.ToolCursor;
import mirrg.simulation.cart.almandine.mods.vanilla.HRender;

public class ToolCursorScreen extends ToolCursor
{

	public ToolCursorScreen(IFrameGameAlmandine frameGameAlmandine)
	{
		super(frameGameAlmandine);

		eventManager.register(NitrogenEventMouse.Pressed.class, e -> {
			if (e.mouseEvent.getButton() == MouseEvent.BUTTON1) {
				// 左押下

			beginLeft = new Point(e.mouseEvent.getX(), e.mouseEvent.getY());
			endLeft = new Point(e.mouseEvent.getX(), e.mouseEvent.getY());

		} else if (e.mouseEvent.getButton() == MouseEvent.BUTTON3) {
			// 右押下

			beginRight = new Point(e.mouseEvent.getX(), e.mouseEvent.getY());
			endRight = new Point(e.mouseEvent.getX(), e.mouseEvent.getY());

		}
	}	);
		eventManager.register(NitrogenEventMouse.Released.class, e -> {
			if (e.mouseEvent.getButton() == MouseEvent.BUTTON1) {
				// 左離す

			beginLeft = null;
			endLeft = null;

		} else if (e.mouseEvent.getButton() == MouseEvent.BUTTON3) {
			// 右離す

			beginRight = null;
			endRight = null;

		}
	}	);
		eventManager.register(NitrogenEventMouseMotion.Dragged.class, e -> {
			if (beginLeft != null) {
				// 左ドラッグ

			Point now = new Point(e.mouseEvent.getX(), e.mouseEvent.getY());

			getGame().getOffsetX().value += now.x - endLeft.x;
			getGame().getOffsetY().value += now.y - endLeft.y;

			endLeft = new Point(e.mouseEvent.getX(), e.mouseEvent.getY());

		}
		if (beginRight != null) {
			// 右ドラッグ

			endRight = new Point(e.mouseEvent.getX(), e.mouseEvent.getY());

		}
	}	);
		eventManager.register(NitrogenEventToolCursor.Tick.class, e -> {
			if (beginRight != null) {
				// 右ドラッグ

			// 描画位置変更が描画中にかぶさると正常に描画位置が戻らなくなる
			SwingUtilities.invokeLater(() -> {
				if (beginRight == null) return;
				if (endRight == null) return;
				getGame().getOffsetX().value += (int) ((endRight.x - beginRight.x) * 0.1);
				getGame().getOffsetY().value += (int) ((endRight.y - beginRight.y) * 0.1);
			});

		}
	}	);
		eventManager.register(NitrogenEventToolCursor.Render.class, e -> {
			if (beginLeft != null) {
				// 左ドラッグ

			e.graphics.setColor(Color.red);
			e.graphics.drawLine(beginLeft.x, beginLeft.y, endLeft.x, endLeft.y);

		}
		if (beginRight != null) {
			// 右ドラッグ

			e.graphics.setColor(Color.red);

			Stroke stroke = e.graphics.getStroke();
			e.graphics.setStroke(new BasicStroke(2));
			{
				e.graphics.drawOval(beginRight.x - 6, beginRight.y - 6, 12, 12);
			}
			e.graphics.setStroke(stroke);

			HRender.drawLine(e.graphics,
				beginRight, endRight,
				6 + 1, 0, 0, 1);

		}
	}	);
	}

	@Override
	public String getLocalizedName()
	{
		return "画面";
	}

	private Point beginLeft;
	private Point beginRight;
	private Point endLeft;
	private Point endRight;

	@Override
	public String getLocalizedDescription()
	{
		return "左ドラッグで画面移動、右ドラッグホールドで滑らかに画面移動";
	}

}
