package mirrg.simulation.cart.almandine;

import java.awt.Graphics2D;
import java.util.Optional;

import mirrg.simulation.cart.almandine.facroty.property.IDialogProperty;
import mirrg.simulation.cart.almandine.gui.toolcursor.ToolCursor;
import mirrg.swing.helium.FrameMirrg;

public interface IFrameGameAlmandine
{

	public GameAlmandine getGame();

	public int getScreenWidth();

	public int getScreenHeight();

	public FrameMirrg getFrame();

	public ToolCursor getToolCursor();

	public void setToolCursor(ToolCursor toolCursor);

	public Optional<IDialogProperty> createDialogProperty(String name);

	public default int getXCoord(int screenX)
	{
		return screenX - getGame().getOffsetX().value - getScreenWidth() / 2;
	}

	public default int getYCoord(int screenY)
	{
		return screenY - getGame().getOffsetY().value - getScreenHeight() / 2;
	}

	public default void doTranslate(Graphics2D graphics, Runnable runnable)
	{
		graphics.translate(getScreenWidth() / 2, getScreenHeight() / 2);
		graphics.translate(getGame().getOffsetX().value, getGame().getOffsetY().value);

		runnable.run();

		graphics.translate(-getGame().getOffsetX().value, -getGame().getOffsetY().value);
		graphics.translate(-getScreenWidth() / 2, -getScreenHeight() / 2);
	}

}
