package mirrg.simulation.cart.almandine;

import java.util.ArrayList;

import mirrg.simulation.cart.almandine.gui.FrameAlmandine;
import mirrg.simulation.cart.almandine.mod.HAlmandineForge;
import mirrg.simulation.cart.almandine.mod.ModBase;
import mirrg.simulation.cart.almandine.mod.NitrogenEventAlmandine;
import mirrg.struct.hydrogen.Struct1;
import mirrg.swing.helium.HSwing;

public class MainAlmandine
{

	public static ArrayList<ModBase> mods = new ArrayList<>();

	private static void init()
	{
		HSwing.setWindowsLookAndFeel();
	}

	public static void main()
	{
		init();

		Struct1<FrameAlmandine> frameAlmandine = new Struct1<>();

		// 各種登録イベント
		HAlmandineForge.eventManager.post(new NitrogenEventAlmandine.InitToolCursor(() -> frameAlmandine.x));
		HAlmandineForge.eventManager.post(new NitrogenEventAlmandine.InitDialogProperty());

		// 各種ウィンドウ＆ゲームインスタンスの生成
		frameAlmandine.x = new FrameAlmandine();

		// run
		frameAlmandine.x.setVisible(true);

	}

}
