package mirrg.simulation.cart.almandine.gui;

import static mirrg.swing.helium.GroupBuilder.*;

import java.awt.Point;
import java.awt.event.ActionListener;
import java.util.ArrayList;

import javax.swing.Box;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableModel;

import mirrg.simulation.cart.almandine.IFrameGameAlmandine;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.factory.Primary;
import mirrg.struct.hydrogen.Tuple3;
import mirrg.swing.helium.DialogMirrg;

public class DialogPrimaries extends DialogMirrg
{

	private IFrameGameAlmandine frameGameAlmandine;
	private JScrollPane scrollPane;
	private DefaultTableModel tableModel;
	private DefaultListSelectionModel listSelectionModel;
	private boolean cancelEventSelection = false;

	public DialogPrimaries(IFrameGameAlmandine frameGameAlmandine)
	{
		super(frameGameAlmandine.getFrame(), "プライマリエンティティ");
		this.frameGameAlmandine = frameGameAlmandine;

		{

			// scroll pane
			{
				scrollPane = new JScrollPane();
				add(scrollPane);

				refreshAll();
				onTick.add(this::refresh);
			}

			GroupLayout layout = new GroupLayout(getContentPane());

			group(
				group(
					scrollPane,
					group(
						button("更新", e -> {
							refreshAll();
						}),
						button("最背面へ", e -> {
							frameGameAlmandine.getGame().factory.hookEditPrimaries(() -> {
								ArrayList<ArrayList<Primary>> listPrimaries = splitPrimaries(frameGameAlmandine.getGame().factory.primaries);
								ArrayList<Primary> primaries = new ArrayList<>();

								// 全ての未選択が老いて、選択済みが若い
								primaries.addAll(listPrimaries.get(3));
								primaries.addAll(listPrimaries.get(0));
								primaries.addAll(listPrimaries.get(1));
								primaries.addAll(listPrimaries.get(2));

								frameGameAlmandine.getGame().factory.primaries = primaries;
							});
						}),
						button("背面へ", e -> {
							frameGameAlmandine.getGame().factory.hookEditPrimaries(() -> {
								ArrayList<ArrayList<Primary>> listPrimaries = splitPrimaries(frameGameAlmandine.getGame().factory.primaries);
								ArrayList<Primary> primaries = new ArrayList<>();

								// forward, selected, unselected, backward
								primaries.addAll(listPrimaries.get(0));
								primaries.addAll(listPrimaries.get(3));
								primaries.addAll(listPrimaries.get(1));
								primaries.addAll(listPrimaries.get(2));

								frameGameAlmandine.getGame().factory.primaries = primaries;
							});
						}),
						button("前面へ", e -> {
							frameGameAlmandine.getGame().factory.hookEditPrimaries(() -> {
								ArrayList<ArrayList<Primary>> listPrimaries = splitPrimaries(frameGameAlmandine.getGame().factory.primaries);
								ArrayList<Primary> primaries = new ArrayList<>();

								// forward, unselected, selected, backward
								primaries.addAll(listPrimaries.get(0));
								primaries.addAll(listPrimaries.get(1));
								primaries.addAll(listPrimaries.get(3));
								primaries.addAll(listPrimaries.get(2));

								frameGameAlmandine.getGame().factory.primaries = primaries;
							});
						}),
						button("最前面へ", e -> {
							frameGameAlmandine.getGame().factory.hookEditPrimaries(() -> {
								ArrayList<ArrayList<Primary>> listPrimaries = splitPrimaries(frameGameAlmandine.getGame().factory.primaries);
								ArrayList<Primary> primaries = new ArrayList<>();

								// 全ての未選択が若く、選択済みが老いる
								primaries.addAll(listPrimaries.get(0));
								primaries.addAll(listPrimaries.get(1));
								primaries.addAll(listPrimaries.get(2));
								primaries.addAll(listPrimaries.get(3));

								frameGameAlmandine.getGame().factory.primaries = primaries;
							});
						}),
						button("プロパティ", e -> {
							frameGameAlmandine.getGame().factory.hookEditPrimaries(() -> {
								ArrayList<ArrayList<Primary>> listPrimaries = splitPrimaries(frameGameAlmandine.getGame().factory.primaries);

								// 全ての選択済みのプロパティを表示
								listPrimaries.get(3).forEach(primary -> primary.openWindowProperty(frameGameAlmandine));

							});
						}),
						Box.createVerticalGlue(),
						button("削除", e -> {
							frameGameAlmandine.getGame().factory.hookEditPrimaries(() -> {
								ArrayList<ArrayList<Primary>> listPrimaries = splitPrimaries(frameGameAlmandine.getGame().factory.primaries);
								ArrayList<Primary> primaries = new ArrayList<>();

								// 全ての未選択を選択
								primaries.addAll(listPrimaries.get(0));
								primaries.addAll(listPrimaries.get(1));
								primaries.addAll(listPrimaries.get(2));

								frameGameAlmandine.getGame().factory.primaries = primaries;
							});
						})
					)
				)).apply(layout);

			layout.setAutoCreateGaps(true);
			layout.setAutoCreateContainerGaps(true);
			setLayout(layout);
		}

		enabledTick = true;
		msTick = 500;

		setDefaultCloseOperation(HIDE_ON_CLOSE);
		pack();
		setLocationByPlatform(true);
	}

	/**
	 * @return forward, unselected, backward, selected
	 */
	private ArrayList<ArrayList<Primary>> splitPrimaries(ArrayList<Primary> primaries)
	{

		// 最も若い番号で選択されたプライマリの1つ前のプライマリよりも若いプライマリ
		ArrayList<Primary> primariesForward = new ArrayList<>();

		// 最も老いた番号で選択されたプライマリの1つ後のプライマリよりも老いたプライマリ
		ArrayList<Primary> primariesBackward = new ArrayList<>();

		// 上記2つ以外の選択されていないプライマリ
		ArrayList<Primary> primariesUnselected = new ArrayList<>();

		// 選択されているプライマリ
		ArrayList<Primary> primariesSelected = new ArrayList<>();

		// 選択された領域の計算
		int indexFirst = -1; // 若い
		int indexLast = -1; // 老いた
		for (int i = 0; i < primaries.size(); i++) {
			boolean selected = primaries.get(i).selected;

			if (selected) {
				if (indexFirst == -1) indexFirst = i;
				indexLast = i;
			}

		}

		// 分割
		for (int i = 0; i < primaries.size(); i++) {
			Primary primary = primaries.get(i);

			if (i < indexFirst - 1) {
				primariesForward.add(primary);
				continue;
			}

			if (i > indexLast + 1) {
				primariesBackward.add(primary);
				continue;
			}

			if (primary.selected) {
				primariesSelected.add(primary);
				continue;
			}

			primariesUnselected.add(primary);

		}

		ArrayList<ArrayList<Primary>> listPrimaries = new ArrayList<>();
		listPrimaries.add(primariesForward);
		listPrimaries.add(primariesUnselected);
		listPrimaries.add(primariesBackward);
		listPrimaries.add(primariesSelected);
		return listPrimaries;
	}

	private void refresh()
	{
		if (tableModel == null) return;

		addRows(tableModel, listSelectionModel);

		scrollPane.repaint();
	}

	private void addRows(DefaultTableModel tableModel, DefaultListSelectionModel listSelectionModel)
	{
		cancelEventSelection = true;
		{

			while (tableModel.getRowCount() > 0) {
				tableModel.removeRow(0);
			}

			ArrayList<Primary> primaries = frameGameAlmandine.getGame().factory.primaries;
			for (int row = 0; row < primaries.size(); row++) {

				Primary primary = primaries.get(row);
				Point point;
				try {
					point = primary.getPoint();
				} catch (IllegalEntityIdException e1) {
					point = new Point(-9999, -9999);
				}
				tableModel.addRow(new Object[] {
					primary.getClass().getSimpleName(),
					point.x,
					point.y,
					primary.getId(),
					primary,
				});

				if (primary.selected) listSelectionModel.addSelectionInterval(row, row);
			}

		}
		cancelEventSelection = false;
	}

	private Tuple3<JTable, DefaultTableModel, DefaultListSelectionModel> createTable()
	{

		// 編集可能設定
		DefaultTableModel tableModel = new DefaultTableModel(0, 5) {

			@Override
			public Class<?> getColumnClass(int column)
			{
				return String.class;
			}

			@Override
			public boolean isCellEditable(int row, int column)
			{
				return false;
			}

		};

		// 列ラベル
		tableModel.setColumnIdentifiers(new Object[] {
			"型",
			"X",
			"Y",
			"ID",
			"物体",
		});

		// セレクションモデル
		DefaultListSelectionModel listSelectionModel = new DefaultListSelectionModel();
		listSelectionModel.addListSelectionListener(this::selectionChanged);

		// 全てのプロパティの書き出し
		addRows(tableModel, listSelectionModel);

		// テーブル生成
		JTable table = new JTable(tableModel);
		table.setSelectionModel(listSelectionModel);
		return new Tuple3<>(table, tableModel, listSelectionModel);
	}

	public void selectionChanged(ListSelectionEvent e)
	{
		if (cancelEventSelection) return;
		if (tableModel == null) return;
		if (listSelectionModel == null) return;

		for (int row = e.getFirstIndex(); row <= e.getLastIndex(); row++) {
			if (row >= tableModel.getRowCount()) break;

			Primary primary = (Primary) tableModel.getValueAt(row, 4);
			primary.selected = listSelectionModel.isSelectedIndex(row);

		}
	}

	private void refreshAll()
	{
		Tuple3<JTable, DefaultTableModel, DefaultListSelectionModel> res = createTable();
		scrollPane.setViewportView(res.getX());
		tableModel = res.getY();
		listSelectionModel = res.getZ();

		scrollPane.repaint();
	}

	private JButton button(String title, ActionListener listener)
	{
		JButton button = new JButton(title);
		button.addActionListener(listener);
		return button;
	}

}
