package mirrg.simulation.cart.almandine.gui;

import java.awt.CardLayout;
import java.awt.event.KeyEvent;
import java.io.File;
import java.net.URL;
import java.util.Optional;

import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileNameExtensionFilter;

import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.IFrameGameAlmandine;
import mirrg.simulation.cart.almandine.facroty.property.ICreatorDialogProperty;
import mirrg.simulation.cart.almandine.facroty.property.IDialogProperty;
import mirrg.simulation.cart.almandine.facroty.property.RegistryDialogProperty;
import mirrg.simulation.cart.almandine.gui.toolcursor.ShortcutKey;
import mirrg.simulation.cart.almandine.gui.toolcursor.ToolCursor;
import mirrg.simulation.cart.almandine.mod.HAlmandineForge;
import mirrg.simulation.cart.almandine.mod.NitrogenEventAlmandine;
import mirrg.swing.helium.FrameMirrg;
import mirrg.swing.helium.logging.FrameLog;
import mirrg.swing.helium.logging.HLog;
import mirrg.swing.helium.property.DialogProperties;
import mirrg.util.HString;

public class FrameAlmandine extends FrameMirrg implements IFrameGameAlmandine
{

	private DialogProperties dialogProperties = null;
	private DialogTools dialogTools = null;
	private DialogPrimaries dialogPrimaries = null;
	private final PanelAlmandine panel;

	private GameAlmandine game;

	public FrameAlmandine()
	{
		super();

		resetGame();

		// GUI
		{

			{
				JMenuBar menuBar = new JMenuBar();
				setJMenuBar(menuBar);

				{
					JMenu menu = new JMenu("ファイル(F)");
					menuBar.add(menu);

					menu.setMnemonic('F');

					{
						JMenuItem menuItem = new JMenuItem("開く...(O)");
						menu.add(menuItem);

						menuItem.setAccelerator(new ShortcutKey(KeyEvent.VK_O).control().toKeyStroke());
						menuItem.setMnemonic('O');
						menuItem.addActionListener(e -> {

							showDialogLoad();

						});
					}

					{
						JMenuItem menuItem = new JMenuItem("上書き保存(S)");
						menu.add(menuItem);

						menuItem.setAccelerator(new ShortcutKey(KeyEvent.VK_S).control().toKeyStroke());
						menuItem.setMnemonic('S');
						menuItem.addActionListener(e -> {

							if (file != null) {
								getGame().save(file);
							} else {
								showDialogSave();
							}

						});
						menu.addMenuListener(new MenuListener() { // TODO MIRRG

							@Override
							public void menuSelected(MenuEvent e)
							{
								menuItem.setEnabled(file != null);
							}

							@Override
							public void menuDeselected(MenuEvent e)
							{

							}

							@Override
							public void menuCanceled(MenuEvent e)
							{

							}

						});
					}

					{
						JMenuItem menuItem = new JMenuItem("名前を付けて保存...(A)");
						menu.add(menuItem);

						menuItem.setAccelerator(new ShortcutKey(KeyEvent.VK_A).control().toKeyStroke());
						menuItem.setMnemonic('A');
						menuItem.addActionListener(e -> {

							showDialogSave();

						});
					}

					menu.addSeparator();

					{
						JMenuItem menuItem = new JMenuItem("ファクトリーの初期化...(N)");
						menu.add(menuItem);

						menuItem.setAccelerator(new ShortcutKey(KeyEvent.VK_N).control().toKeyStroke());
						menuItem.setMnemonic('N');
						menuItem.addActionListener(e -> {

							resetGame();
							HLog.fine("ファクトリを初期化しました。");

						});
					}

				}

				{
					JMenu menu = new JMenu("ウィンドウ(W)");
					menuBar.add(menu);

					menu.setMnemonic('W');

					{
						JMenuItem menuItem = new JMenuItem("ツール...(T)");
						menu.add(menuItem);

						menuItem.setAccelerator(new ShortcutKey(KeyEvent.VK_T).control().toKeyStroke());
						menuItem.setMnemonic('T');
						menuItem.addActionListener(e -> {
							if (dialogTools == null) {
								dialogTools = new DialogTools(this);
							}
							dialogTools.setVisible(true);
						});
						hookDisposed(e -> {
							if (dialogTools != null) dialogTools.dispose();
						});
					}

					{
						JMenuItem menuItem = new JMenuItem("プライマリエンティティ...(E)");
						menu.add(menuItem);

						menuItem.setAccelerator(new ShortcutKey(KeyEvent.VK_E).control().toKeyStroke());
						menuItem.setMnemonic('E');
						menuItem.addActionListener(e -> {
							if (dialogPrimaries == null) {
								dialogPrimaries = new DialogPrimaries(this);
							}
							dialogPrimaries.setVisible(true);
						});
						hookDisposed(e -> {
							if (dialogPrimaries != null) dialogPrimaries.dispose();
						});
					}

					{
						JMenuItem menuItem = new JMenuItem("プロパティマネージャ...(P)");
						menu.add(menuItem);

						menuItem.setAccelerator(new ShortcutKey(KeyEvent.VK_P).control().toKeyStroke());
						menuItem.setMnemonic('P');
						menuItem.addActionListener(e -> {
							if (dialogProperties == null) {
								dialogProperties = new DialogProperties(this, () -> getGame().managerProperty);
							}
							dialogProperties.setVisible(true);
						});
						hookDisposed(e -> {
							if (dialogProperties != null) dialogProperties.dispose();
						});
					}

					{
						JMenuItem menuItem = new JMenuItem("ログウィンドウ...(L)");
						menu.add(menuItem);

						menuItem.setAccelerator(new ShortcutKey(KeyEvent.VK_L).control().toKeyStroke());
						menuItem.setMnemonic('L');
						menuItem.addActionListener(e -> {

							FrameLog frame = new FrameLog(200);
							hookDisposed(e2 -> {
								frame.dispose();
							});
							frame.setVisible(true);

						});
					}

					menu.addSeparator();

					{
						JMenuItem menuItem = new JMenuItem("ツールウィンドウの初期化(R)");
						menu.add(menuItem);

						menuItem.setMnemonic('R');
						menuItem.addActionListener(e -> {

							if (dialogProperties != null) {
								dialogProperties.dispose();
								dialogProperties = null;
							}

							if (dialogTools != null) {
								dialogTools.dispose();
								dialogTools = null;
							}

							if (dialogPrimaries != null) {
								dialogPrimaries.dispose();
								dialogPrimaries = null;
							}

						});
					}

				}

				{
					JMenu menu = new JMenu("進行速度(S)");
					menuBar.add(menu);

					menu.setMnemonic('S');

					addMenuItemSpped(menu, "停止", '0', KeyEvent.VK_0, 1, 0);
					addMenuItemSpped(menu, ">", '1', KeyEvent.VK_1, 1, 1);
					addMenuItemSpped(menu, ">", '2', KeyEvent.VK_2, 1, 3);
					addMenuItemSpped(menu, ">", '3', KeyEvent.VK_3, 1, 10);
					addMenuItemSpped(menu, ">", '4', KeyEvent.VK_4, 1, 30);
					addMenuItemSpped(menu, ">", '5', KeyEvent.VK_5, 1, 60);
					addMenuItemSpped(menu, ">", '6', KeyEvent.VK_6, 1, 100);
					addMenuItemSpped(menu, ">>", '7', KeyEvent.VK_7, 3, 60);
					addMenuItemSpped(menu, ">>", '8', KeyEvent.VK_8, 10, 60);
					addMenuItemSpped(menu, ">>", '9', KeyEvent.VK_9, 60, 60);

				}

			}

			{
				setLayout(new CardLayout());

				{
					panel = new PanelAlmandine(this);
					getContentPane().add(panel);

					hookInitialized(e -> panel.init());
					hookShown(e -> panel.start());
					hookHidden(e -> panel.stop());
					hookDisposed(e -> panel.destroy());
				}

			}

			{
				URL url = getClass().getResource("icon.png");
				if (url != null) {
					setIconImage(new ImageIcon(url).getImage());
				} else {
					HLog.warning("アイコンファイルの読み込みに失敗しました。");
				}
			}

		}

		hookShown(e -> updateTitle());

		prepareFrame();
	}

	public void resetGame()
	{

		game = new GameAlmandine();
		HAlmandineForge.eventManager.post(new NitrogenEventAlmandine.CreatedGame(game));

		game.getTickPerFrame().value = 0;

		file = null;
		updateTitle();

	}

	private void addMenuItemSpped(
		JMenu menu,
		String title,
		char mnemonic,
		int keyCode,
		double secondPerTick,
		int tickPerFrame)
	{
		JMenuItem menuItem = new JMenuItem(String.format(
			"%s (spt=%s, tpf=%s)(%s)",
			title,
			secondPerTick,
			tickPerFrame,
			mnemonic));
		menu.add(menuItem);

		menuItem.setAccelerator(new ShortcutKey(keyCode).toKeyStroke());
		menuItem.setMnemonic(mnemonic);
		menuItem.addActionListener(e -> {
			game.getSecondPerTick().value = secondPerTick;
			game.getTickPerFrame().value = tickPerFrame;
		});
	}

	///////////////////////////////// title /////////////////////////////////

	private String suffixTitle = "Almandine Cart Simulator";

	public void updateTitle()
	{
		StringBuilder sb = new StringBuilder();

		if (file != null) sb.append(HString.deleteExtension(file.getName()));

		if (sb.length() != 0) sb.append(" - ");
		sb.append(suffixTitle);

		setTitle(sb.toString());
	}

	///////////////////////////////// file /////////////////////////////////

	private static final FileNameExtensionFilter FILTER = new FileNameExtensionFilter("Almandine保存ファイル(*.alm)", "alm");
	private JFileChooser _fileChooser = null;
	private File file = null;

	private JFileChooser getFileChooser()
	{
		if (_fileChooser == null) {
			_fileChooser = new JFileChooser();
			_fileChooser.addChoosableFileFilter(FILTER);
			_fileChooser.setAcceptAllFileFilterUsed(true);
			_fileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
		}
		return _fileChooser;
	}

	private void showDialogLoad()
	{
		JFileChooser fileChooser = getFileChooser();

		// ファイル選択
		int res = fileChooser.showOpenDialog(this);
		if (res == JFileChooser.CANCEL_OPTION) {
			HLog.info("ダイアログがキャンセルされました。");
			return;
		} else if (res == JFileChooser.ERROR_OPTION) {
			HLog.error("ダイアログ上でエラーが発生しました！: " + res);
			return;
		}
		File file = fileChooser.getSelectedFile();

		GameAlmandine game = GameAlmandine.load(file);
		if (game != null) {
			this.game = game;
			HLog.fine("設定ファイルを正常に読み込みました。: " + file.getPath());

			this.file = file;
			updateTitle();

			game.getTickPerFrame().value = 0;
		}

	}

	private void showDialogSave()
	{
		JFileChooser fileChooser = getFileChooser();

		// ファイル選択
		int res = fileChooser.showSaveDialog(this);
		if (res == JFileChooser.CANCEL_OPTION) {
			HLog.info("ダイアログがキャンセルされました。");
			return;
		} else if (res == JFileChooser.ERROR_OPTION) {
			HLog.error("ダイアログ上でエラーが発生しました！: " + res);
			return;
		}
		File file = fileChooser.getSelectedFile();

		if (fileChooser.getFileFilter() == FILTER) {
			String path = file.getAbsolutePath();
			if (path.equals(HString.deleteExtension(path))) {
				path = path + ".alm";
			}
			file = new File(path);
		}

		this.file = file;
		updateTitle();

		getGame().save(file);
	}

	@Override
	public GameAlmandine getGame()
	{
		return game;
	}

	@Override
	public int getScreenWidth()
	{
		return panel.getWidth();
	}

	@Override
	public int getScreenHeight()
	{
		return panel.getHeight();
	}

	@Override
	public FrameMirrg getFrame()
	{
		return this;
	}

	@Override
	public ToolCursor getToolCursor()
	{
		return panel.toolCursor;
	}

	@Override
	public void setToolCursor(ToolCursor toolCursor)
	{
		panel.toolCursor = toolCursor;
	}

	@Override
	public Optional<IDialogProperty> createDialogProperty(String name)
	{
		String idDialogProperty = game.getIdDialogProperty().value;
		Optional<ICreatorDialogProperty> optionalCreatorDialogProperty =
			RegistryDialogProperty.instance.get(idDialogProperty);

		if (!optionalCreatorDialogProperty.isPresent()) {
			HLog.warning("unknown DialogProperty ID: " + idDialogProperty);
		}

		return optionalCreatorDialogProperty
			.map(creatorDialogProperty -> creatorDialogProperty.create(this, name));
	}

}
