package mirrg.swing.helium.property;

import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;

import mirrg.struct.hydrogen.Struct1;

/**
 * このクラスはXStream互換です。
 */
public class ManagerProperty
{

	private ArrayList<Property<?>> properties = new ArrayList<>();

	public Stream<Property<?>> getProperties()
	{
		return properties.stream();
	}

	public Optional<Property<?>> getProperty(String id)
	{
		return properties.stream()
			.filter(property -> property.id.equals(id))
			.findFirst();
	}

	public synchronized void addProperty(Property<?> property)
	{
		properties.add(property);
	}

	public static interface ICreatorProperty<P extends Property<T>, T>
	{

		public P create(String id, String name, T defaultValue);

	}

	public <P extends Property<T>, T> P createProperty(
		ICreatorProperty<P, T> creatorProperty,
		T defaultValue,
		String id,
		String name)
	{
		P property = creatorProperty.create(id, name, defaultValue);
		addProperty(property);
		return property;
	}

	public <P extends Property<T>, T> Supplier<P> getOrCreateProperty(
		ICreatorProperty<P, T> creatorProperty,
		Class<P> classProperty,
		T defaultValue,
		String id,
		String name)
	{
		Struct1<P> structProperty = new Struct1<>();

		return () -> {

			if (structProperty.x == null) {

				@SuppressWarnings("unchecked")
				P property = properties.stream()
					.filter(property2 -> property2.id.equals(id))
					.filter(property2 -> classProperty.isInstance(property2))
					.findFirst()
					.map(property2 -> (P) property2)
					.orElse(null);

				if (property != null) {
					structProperty.x = property;
				} else {
					structProperty.x = createProperty(creatorProperty, defaultValue, id, name);
				}

			}

			return structProperty.x;
		};
	}

}
