package mirrg.swing.helium.property;

public class PropertyDouble extends Property<Double>
{

	public double value;

	public PropertyDouble(String id, String name, double value)
	{
		super(id, name);
		this.value = value;
	}

	@Override
	public String getString()
	{
		return Double.toString(value);
	}

	@Override
	public boolean setString(String string)
	{
		try {
			value = Double.parseDouble(string);
		} catch (NumberFormatException e) {
			return false;
		}
		return true;
	}

	@Override
	public String getType()
	{
		return "Double";
	}

}
