package mirrg.swing.helium.v1_0;

import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.function.Consumer;

import javax.swing.JFrame;
import javax.swing.WindowConstants;

public class FrameMirrg extends JFrame {

	public FrameMirrg() throws HeadlessException {
		super();
		initFrameMirrg();
	}

	public FrameMirrg(GraphicsConfiguration gc) {
		super(gc);
		initFrameMirrg();
	}

	public FrameMirrg(String title) throws HeadlessException {
		super(title);
		initFrameMirrg();
	}

	public FrameMirrg(String title, GraphicsConfiguration gc) {
		super(title, gc);
		initFrameMirrg();
	}

	// //////////////////////////////////////////////

	private ArrayList<Consumer<WindowEvent>> listenersOnInitialized = new ArrayList<>();
	private ArrayList<Consumer<ComponentEvent>> listenersOnShown = new ArrayList<>();
	private ArrayList<Consumer<ComponentEvent>> listenersOnHidden = new ArrayList<>();
	private ArrayList<Consumer<WindowEvent>> listenersOnDisposed = new ArrayList<>();

	/**
	 * 初回open時
	 */
	public void hookInitialized(Consumer<WindowEvent> listener) {
		listenersOnInitialized.add(listener);
	}

	/**
	 * 初回も含めてウィンドウが開くとき
	 */
	public void hookShown(Consumer<ComponentEvent> listener) {
		listenersOnShown.add(listener);
	}

	/**
	 * disposeも含めてウィンドウが閉じるとき
	 */
	public void hookHidden(Consumer<ComponentEvent> listener) {
		listenersOnHidden.add(listener);
	}

	/**
	 * disposeするとき
	 */
	public void hookDisposed(Consumer<WindowEvent> listener) {
		listenersOnDisposed.add(listener);
	}

	// //////////////////////////////////////////////

	private boolean visible = false;

	private void initFrameMirrg() {
		addComponentListener(new ComponentListener() {

			@Override
			public void componentShown(ComponentEvent e) {
				visible = true;

				listenersOnShown.forEach(listener -> {
					listener.accept(e);
				});
			}

			@Override
			public void componentResized(ComponentEvent e) {

			}

			@Override
			public void componentMoved(ComponentEvent e) {

			}

			@Override
			public void componentHidden(ComponentEvent e) {
				visible = false;

				listenersOnHidden.forEach(listener -> {
					listener.accept(e);
				});
			}

		});
		addWindowListener(new WindowListener() {

			@Override
			public void windowOpened(WindowEvent e) {
				listenersOnInitialized.forEach(listener -> {
					listener.accept(e);
				});
			}

			@Override
			public void windowIconified(WindowEvent e) {

			}

			@Override
			public void windowDeiconified(WindowEvent e) {

			}

			@Override
			public void windowDeactivated(WindowEvent e) {

			}

			@Override
			public void windowClosing(WindowEvent e) {

			}

			@Override
			public void windowClosed(WindowEvent e) {
				if (visible) {
					listenersOnHidden.forEach(listener -> {
						listener.accept(e);
					});
				}
				listenersOnDisposed.forEach(listener -> {
					listener.accept(e);
				});
			}

			@Override
			public void windowActivated(WindowEvent e) {

			}

		});
	}

	private volatile boolean isDisposed = false;

	/**
	 * スレッドセーフ
	 */
	public boolean isDisposed() {
		return isDisposed;
	}

	@Override
	public void dispose() {
		isDisposed = true;
		super.dispose();
	}

	// //////////////////////////////////////////////

	public void prepareFrame() {
		setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);

		pack();
		setLocationByPlatform(true);
	}

}
