$(function() {
  window.setTimeout(function() {
    $("#offer_code").focus();
  }, 50);
  $("#search").click(function() {
    $("#frm").attr("action", "/back/offer_list/search").submit();
  });
  $("#clear").click(function() {
    $(".search").each(function() {
      $(this).val("");
    });
    $(".status").val([ "all" ]);
    $("#offer_code").focus();
  });
  $(".del_offer").click(function() {
    if (!confirm("「" + $(this).val() + "」を削除しますか？")) {
      return;
    }
    $("#frm").attr("action", "/back/offer_list/delete/" + $(this).val()).submit();
  });
  $("#prefecture").change(function() {
    $("#city").empty();
    $("#ward").empty();
    $.ajax({
      type : "post",
      cache : false,
      url : "/back/area/city",
      dataType : "json",
      data : {
        "prefectureId" : $(this).val()
      }
    }).done(function(data) {
      $("#city").append($("<option>"));
      $.each(data, function(key, val) {
        $("#city").append($("<option>").val(key).text(val));
      });
    });
  });
  $("#city").change(function() {
    $("#ward").empty();
    $.ajax({
      type : "post",
      cache : false,
      url : "/back/area/ward",
      dataType : "json",
      data : {
        "prefectureId" : $("#prefecture").val(),
        "cityId" : $(this).val()
      }
    }).done(function(data) {
      $("#ward").append($("<option>"));
      $.each(data, function(key, val) {
        $("#ward").append($("<option>").val(key).text(val));
      });
    });
  });
});
