<?php
final class OccupationDao extends Dao {
  private static $ALL = <<<'SQL'
select occupation_id,
       occupation_name
  from occupation
 order by occupation_id
SQL;
  private static $PK = <<<'SQL'
select occupation_id,
       occupation_name
  from occupation
 where occupation_id = %s
SQL;
  private static $UPDATE = <<<'SQL'
update occupation
   set occupation_name = '%s'
 where occupation_id = %s
SQL;
  private static $INSERT = <<<'SQL'
insert into occupation
            (occupation_id,
             occupation_name)
     values (null,
             '%s')
SQL;
  private static $LAST_INSERT_ID = <<<'SQL'
select LAST_INSERT_ID()
SQL;
  private static $DELETE = <<<'SQL'
delete from occupation
 where occupation_id = %s
SQL;
  private static $DELETE_CATEGORY = <<<'SQL'
delete from category
 where occupation_id = %s
SQL;
  private static $DELETE_CONTENT = <<<'SQL'
delete from content
 where occupation_id = %s
SQL;
  private static $DELETE_OFFER = <<<'SQL'
delete from offer_outline
 where occupation_id = %s
SQL;

  public function getAll() {
    return $this->execute(self::$ALL);
  }
  public function getByPk($pk) {
    return $this->execute(self::$PK, $pk);
  }
  public function update($name, $occupationId) {
    $this->execute(self::$UPDATE, array($name, $occupationId));
  }
  public function insert($occupationName) {
    $this->execute(self::$INSERT, $occupationName);
    return mysql_result($this->execute(self::$LAST_INSERT_ID), 0);
  }
  public function delete($occupationId) {
    $this->execute(self::$DELETE, $occupationId);
    $this->execute(self::$DELETE_CATEGORY, $occupationId);
    $this->execute(self::$DELETE_CONTENT, $occupationId);
    $this->execute(self::$DELETE_OFFER, $occupationId);
  }
}
// EOF.
