<?php
require_once DTO . 'CelebrateDto.php';
final class CelebrateApply extends Action {
  private $dto;
  public function __construct() {
    $this->dto = new CelebrateDto();
  }
  protected function getDto() {
    return $this->dto;
  }
  public function index() {
    session_start();
    if (!isset($_SESSION['DTO'])) {
      session_destroy();
      $_SESSION = array();
      return new Redirect('', DOMAIN);
    }
    $this->dto = unserialize($_SESSION['DTO']);
    session_destroy();
    $_SESSION = array();
    return new Forward();
  }
  public function apply() {
    session_start();
    if (!isset($_SESSION['DTO'])) {
      session_destroy();
      $_SESSION = array();
      return new Redirect('', DOMAIN);
    }
    $this->dto = unserialize($_SESSION['DTO']);
    $message = mb_convert_kana($this->dto->familyName, 'KVa') . "様から申請頂いた内容です。\n";
    $message .= "■求人番号\n{$this->dto->offerCode}\n";
    $message .= "■店舗名\n{$this->dto->shopName}\n";
    $message .= "■お名前\n" . mb_convert_kana($this->dto->familyName, 'KVa') . " " . mb_convert_kana($this->dto->firstName, 'KVa') . "\n";
    $message .= "■ふりがな\n" . mb_convert_kana($this->dto->familyNameKana, 'KVa') . " " . mb_convert_kana($this->dto->firstNameKana, 'KVa') . "\n";
    $message .= "■電話番号\n{$this->dto->telNo}\n";
    $message .= "■銀行口座\n" . mb_convert_kana($this->dto->bankName . $this->dto->bankKbn, 'KVa') . " " . mb_convert_kana($this->dto->tenName . $this->dto->tenKbn, 'KVa') . "\n";
    $message .= "■普通・総合\n{$this->dto->kozaNo}\n";
    $message .= "■採用決定通知日\n{$this->dto->tutiDate}\n";
    $message .= "■開始日\n{$this->dto->kaisiDate}\n";
    mb_language('Ja');
    mb_internal_encoding('UTF-8');
    mb_send_mail('miura@tns-g.jp', 'セレブレート申請', $message, 'From:Dear job<dear-job@tns-g.jp>');
    $_SESSION['DTO'] = serialize($this->dto);
    return new Redirect('celebrate_apply', SSL);
  }
}
// EOF.
