<?php
require_once DTO . 'InquiryDto.php';
final class InquiryApply extends Action {
  private $dto;
  public function __construct() {
    $this->dto = new InquiryDto();
  }
  protected function getDto() {
    return $this->dto;
  }
  public function index() {
    session_start();
    if (!isset($_SESSION['DTO'])) {
      session_destroy();
      $_SESSION = array();
      return new Redirect('', DOMAIN);
    }
    $this->dto = unserialize($_SESSION['DTO']);
    session_destroy();
    $_SESSION = array();
    return new Forward();
  }
  public function apply() {
    session_start();
    if (!isset($_SESSION['DTO'])) {
      session_destroy();
      $_SESSION = array();
      return new Redirect('', DOMAIN);
    }
    $this->dto = unserialize($_SESSION['DTO']);
    $message = mb_convert_kana($this->dto->name, 'KVa') . "様からお問い合わせ頂いた内容です。\n";
    $message .= "■お名前\n" . mb_convert_kana($this->dto->name, 'KVa') . "\n";
    $message .= "■電話番号\n{$this->dto->telNo}\n";
    $message .= "■メールアドレス\n{$this->dto->email}\n";
    $message .= "■お問い合わせ内容\n{$this->dto->message}\n";
    mb_language('Ja');
    mb_internal_encoding('UTF-8');
    mb_send_mail('miura@tns-g.jp', 'フォームメール送信', $message, 'From:Dear job<dear-job@tns-g.jp>');
    $message = "お問い合わせ頂いた内容です。\n";
    $message .= "■お名前\n" . mb_convert_kana($this->dto->name, 'KVa') . "\n";
    $message .= "■電話番号\n{$this->dto->telNo}\n";
    $message .= "■メールアドレス\n{$this->dto->email}\n";
    $message .= "■お問い合わせ内容\n{$this->dto->message}\n";
    $message .= "------------------------\n";
    $message .= "このメールは、お問い合わせ頂いたメールを受信した事の確認のため、自動返信させて頂いています。\n";
    $message .= "お問い合わせ内容を確認後、ご返答させて頂きますので、今しばらくお待ちください。\n";
    $message .= "------------------------\n";
    $message .= "Dear job（株式会社テクニカルシステムサポート）\n";
    $message .= "TEL：075-864-0104\n";
    mb_send_mail($this->dto->email, 'お問い合わせの受付', $message, 'From:Dear job<dear-job@tns-g.jp>');
    $_SESSION['DTO'] = serialize($this->dto);
    return new Redirect('inquiry_apply', SSL);
  }
}
// EOF.
