<?php
require_once DAO . 'OfferDao.php';
require_once DAO . 'OfferHoursDao.php';
require_once DAO . 'OfferSalaryDao.php';
require_once DAO . 'OfferConditionDao.php';
require_once DAO . 'OfferTimeDao.php';
require_once DTO . 'JobListDto.php';
require_once INTERNAL . 'Pager.php';
final class JobList extends Action {
  private $dto;
  public function __construct() {
    $this->dto = new JobListDto();
  }
  protected function getDto() {
    return $this->dto;
  }
  public function index() {
    return new Redirect('not_found');
  }
  public function recent() {
    $offerdao = new OfferDao();
    $offerHoursDao = new OfferHoursDao();
    $offerSalaryDao = new OfferSalaryDao();
    $offerConditionDao = new OfferConditionDao();
    $offerTimeDao = new OfferTimeDao();
    $pager = new Pager($this->dto->totalRow, $this->dto->currentPage);
    $jobList = $offerdao->getRecent($pager->getStartRow(), Pager::PAGE_ROWS);
    $pager->setTotalRow($offerdao->foundRows());
    $this->dto->totalRow = $pager->getTotalRow();
    $this->dto->totalPage = $pager->getTotalPage();
    while ($row = mysql_fetch_assoc($jobList)) {
      $this->dto->jobList[] = array('offer_code' => $row['offer_code'], 'shop_name' => $row['shop_name'], 'title' => $row['title'], 'celebrate' => $row['celebrate'], 'photo_1' => $row['photo_1'], 'message' => $row['message'], 'address' => $row['address'], 'prefecture_name' => $row['prefecture_name'], 'city_name' => $row['city_name'], 'ward_name' => $row['ward_name']);
      $timeList = $offerHoursDao->getByOfferCode($row['offer_code']);
      while ($time = mysql_fetch_assoc($timeList)) {
        $this->dto->timeList[$row['offer_code']][] = array('start_time' => $time['start_time'], 'start_min' => $time['start_min'], 'end_time' => $time['end_time'], 'end_min' => $time['end_min']);
      }
      $salaryList = $offerSalaryDao->getByOfferCode($row['offer_code']);
      while ($salary = mysql_fetch_assoc($salaryList)) {
        $this->dto->salaryList[$row['offer_code']][] = $salary['salary'];
      }
      $conditionList = $offerConditionDao->getByOfferCode($row['offer_code']);
      while ($condition = mysql_fetch_assoc($conditionList)) {
        $this->dto->conditionList[$row['offer_code']][] = $condition['condition_name'];
      }
      $boxList = $offerTimeDao->getByOfferCode($row['offer_code']);
      while ($box = mysql_fetch_assoc($boxList)) {
        $this->dto->boxList[$row['offer_code']][$box['search_time']] = 'dummy';
      }
    }
    $this->dto->mode = 'recent';
    return new forward();
  }
  public function search() {
    if (session_id() == '') {
      session_cache_limiter('private_no_expire');
      session_start();
    }
    $offerdao = new OfferDao();
    $offerHoursDao = new OfferHoursDao();
    $offerSalaryDao = new OfferSalaryDao();
    $offerConditionDao = new OfferConditionDao();
    $offerTimeDao = new OfferTimeDao();
    $pager = new Pager($this->dto->totalRow, $this->dto->currentPage);
    $jobList = $offerdao->getJobList($this->dto->area, $this->dto->category, $this->dto->time, $this->dto->condition, $this->dto->compensation, $pager->getStartRow(), Pager::PAGE_ROWS);
    $pager->setTotalRow($offerdao->foundRows());
    $this->dto->totalRow = $pager->getTotalRow();
    $this->dto->totalPage = $pager->getTotalPage();
    while ($row = mysql_fetch_assoc($jobList)) {
      $this->dto->jobList[] = array('offer_code' => $row['offer_code'], 'shop_name' => $row['shop_name'], 'title' => $row['title'], 'celebrate' => $row['celebrate'], 'photo_1' => $row['photo_1'], 'message' => $row['message'], 'address' => $row['address'], 'prefecture_name' => $row['prefecture_name'], 'city_name' => $row['city_name'], 'ward_name' => $row['ward_name']);
      $timeList = $offerHoursDao->getByOfferCode($row['offer_code']);
      while ($time = mysql_fetch_assoc($timeList)) {
        $this->dto->timeList[$row['offer_code']][] = array('start_time' => $time['start_time'], 'start_min' => $time['start_min'], 'end_time' => $time['end_time'], 'end_min' => $time['end_min']);
      }
      $salaryList = $offerSalaryDao->getByOfferCode($row['offer_code']);
      while ($salary = mysql_fetch_assoc($salaryList)) {
        $this->dto->salaryList[$row['offer_code']][] = $salary['salary'];
      }
      $conditionList = $offerConditionDao->getByOfferCode($row['offer_code']);
      while ($condition = mysql_fetch_assoc($conditionList)) {
        $this->dto->conditionList[$row['offer_code']][] = $condition['condition_name'];
      }
      $boxList = $offerTimeDao->getByOfferCode($row['offer_code']);
      while ($box = mysql_fetch_assoc($boxList)) {
        $this->dto->boxList[$row['offer_code']][$box['search_time']] = 'dummy';
      }
    }
    $this->dto->mode = 'move';
    $_SESSION['SEARCH'] = serialize(array($this->dto->area, $this->dto->category, $this->dto->time, $this->dto->condition, $this->dto->compensation));
    return new forward();
  }
  public function move() {
    session_cache_limiter('private_no_expire');
    session_start();
    if (isset($_SESSION['SEARCH'])) {
      list($this->dto->area, $this->dto->category, $this->dto->time, $this->dto->condition, $this->dto->compensation) = unserialize($_SESSION['SEARCH']);
      return $this->search();
    }
    return new Redirect('not_found');
  }
}
// EOF.
