<?php
final class KanriAction extends AppAction {
    /**
     * @var KanriDao
     */
    protected $dao = NULL;
    /**
     * @var KanriDto
     */
    protected $dto = NULL;
    public function __construct() {
    }
    /**
     * @return KanriDto
     */
    public function getDto() {
        return $this->dto;
    }
    public function index() {
        $this->dto->setTournaments($this->dao->selectTournament());
        return new SessionForward();
    }
    public function logout() {
        $this->session->clear();
        return new Redirect();
    }
    public function apply() {
        if ($this->dto->getSubmit() == '許可') {
            if ($this->dao->updateTournament($this->dto->getCreaterNo(), $this->dto->getTournamentNo()) == 0) {
                $this->error->add(MessageBehavior::getMessage('ERR006', array('MODIFY_TOURNAMENT', 'REASON_CREATER')));
            }
        } elseif ($this->dto->getSubmit() == '削除') {
            $path = WEB . 'resource' . DIRECTORY_SEPARATOR;
            if ($image = $this->dao->selectImage($this->dto->getCreaterNo(), $this->dto->getTournamentNo())) {
                if (file_exists($path . $image)) {
                    unlink($path . $image);
                }
            }
            if ($this->dao->deleteTournament($this->dto->getCreaterNo(), $this->dto->getTournamentNo()) == 0) {
                $this->error->add(MessageBehavior::getMessage('ERR006', array('MODIFY_TOURNAMENT', 'REASON_CREATER')));
            }
        }
        return $this->index();
    }
}
// EOF.
