<?php
final class LoginAction extends Action {
    /**
     * @var LoginDao
     */
    protected $dao;
    /**
     * @var LoginDto
     */
    protected $dto;
    /**
     * @return LoginDto
     */
    public function getDto() {
        return $this->dto;
    }
    public function __construct() {
    }
    public function index() {
        return new Forward();
    }
    public function apply() {
        if (!$this->_isValid()) {
            return new Forward();
        }
        if (!$userNo = $this->dao->selectUserNo($this->dto->getMailAddress(), $this->dto->getPassword())) {
            $this->error->add(MessageBehavior::getMessage('ERR003', 'LOGIN'));
            return new Forward();
        }
        $this->session->start();
        $uniqueId = md5(uniqid('', TRUE));
        $this->dao->updateUniqueId($uniqueId, $userNo);
        $this->flash->set('uno', $userNo);
        $this->flash->set('uid', $uniqueId);
        if ($userNo == 1) {
            $redirect = 'kanri';
        } else {
            $redirect = 'main';
        }
        return new SessionRedirect($redirect);
    }
    private function _isValid() {
        $valid = TRUE;
        if (!Validator::required($this->dto->getMailAddress())) {
            $this->error->add(MessageBehavior::getMessage('ERR004', 'MAIL_ADDRESS'));
            $valid = FALSE;
        }
        if (!Validator::required($this->dto->getPassword())) {
            $this->error->add(MessageBehavior::getMessage('ERR004', 'PASSWORD'));
            $valid = FALSE;
        }
        return $valid;
    }
}
// EOF.