<?php
final class PreRegisterAction extends Action {
    /**
     * @var PreRegisterDao
     */
    protected $dao;
    /**
     * @var string
     */
    protected $mailAddress;
    /**
     * @return string
     */
    public function getMailAddress() {
        return $this->mailAddress;
    }
    public function __construct() {
    }
    public function index() {
        return new Forward();
    }
    public function apply() {
        if (!Validator::isMailAddress($this->mailAddress)) {
            $this->error->add(MessageBehavior::getMessage('ERR001', 'MAIL_ADDRESS'));
            return new Forward();
        }
        if ($this->dao->selectUserNo($this->mailAddress)) {
            $this->error->add(MessageBehavior::getMessage('ERR002', 'MAIL_ADDRESS'));
            return new Forward();
        }
        $uniqueId = md5(uniqid('', TRUE));
        $this->dao->insertPreRegister($this->mailAddress, $uniqueId);
        $text = "仮登録が完了しました。\r\n";
        $text .= "引き続き下記のURLにアクセスして、本登録をお願いします。\r\n";
        $text .= MailUtil::getHttpDomain() . "accept?uid={$uniqueId}\r\n\r\n";
        $text .= "※上記アドレスの有効期限は30分以内となっております。\r\n";
        $text .= "有効期限を過ぎた場合は、再度「ユーザー登録」画面よりメールを再送信してください。\r\n\r\n";
        $text .= MailUtil::getTextFooter();
        $enc = new Encoder(MailUtil::getSmtp());
        $enc->setFrom(MailUtil::getFromAddress(), MailUtil::getFromName());
        $enc->setTo($this->mailAddress);
        $enc->setSubject('新規ご利用登録の受付けが完了しました');
        $enc->setTextBody($text);
        $enc->send();
        return new Redirect('complete/show/pre_register');
    }
}
// EOF.