<?php
final class IndexDao extends Dao {
    public function __construct() {
    }
    public function selectTournament() {
        $stmt = " select user_no,";
        $stmt .= "       tournament_no,";
        $stmt .= "       tournament_name,";
        $stmt .= "       main_image";
        $stmt .= "  from ms_tournament";
        $stmt .= " where start_flag = 1";
        $stmt .= " order by start_date_time desc";
        $res = $this->pdo->prepare($stmt);
        $res->execute();
        return $res->fetchAll(PDO::FETCH_ASSOC);
    }
    public function selectWinner() {
        $stmt = " select entry_image,";
        $stmt .= "       nickname,";
        $stmt .= "       win_count";
        $stmt .= "  from tr_winner";
        $stmt .= " order by win_count desc";
        $res = $this->pdo->prepare($stmt);
        $res->execute();
        return $res->fetchAll(PDO::FETCH_ASSOC);
            }
    public function selectEntries() {
        $stmt = " select ms.user_no,";
        $stmt .= "       ms.tournament_no,";
        $stmt .= "       ms.tournament_name,";
        $stmt .= "       ms.main_image,";
        $stmt .= "       ms.entry_num,";
        $stmt .= "       (select ifnull(max(entry_no), 0)";
        $stmt .= "          from tr_entry tr";
        $stmt .= "         where tr.user_no = ms.user_no";
        $stmt .= "           and tr.tournament_no= ms.tournament_no) as entry_no";
        $stmt .= "  from ms_tournament ms";
        $stmt .= " where apply_flag = 1";
        $stmt .= "   and start_flag = 0";
        $stmt .= " order by apply_date_time desc";
        $res = $this->pdo->prepare($stmt);
        $res->execute();
        return $res->fetchAll(PDO::FETCH_ASSOC);
    }
}
// EOF.