<?php
final class MainDao extends AppDao {
    public function __construct() {
    }
    public function insertTournament($userNo, $tournamentName, $dest, $original, $entryNum) {
        $stmt = " select ifnull(max(tournament_no) + 1, 1)";
        $stmt .= "  from ms_tournament";
        $stmt .= " where user_no = ?";
        $res = $this->pdo->prepare($stmt);
        $res->execute(array($userNo));
        $tournamentNo = $res->fetchColumn();
        $res->closeCursor();
        $stmt = "  insert into ms_tournament(user_no, tournament_no, tournament_name, main_image, original_file_name, entry_num, create_date_time)";
        $stmt .= " values (?, ?, ?, ?, ?, ?, now())";
        $res = $this->pdo->prepare($stmt);
        $res->execute(array($userNo, $tournamentNo, $tournamentName, $dest, $original, $entryNum));
    }
    public function selectTournament($userNo) {
        $stmt = " select tournament_no,";
        $stmt .= "       tournament_name,";
        $stmt .= "       main_image,";
        $stmt .= "       entry_num,";
        $stmt .= "       apply_flag";
        $stmt .= "  from ms_tournament";
        $stmt .= " where user_no = ?";
        $stmt .= " order by create_date_time desc";
        $res = $this->pdo->prepare($stmt);
        $res->execute(array($userNo));
        return $res->fetchAll(PDO::FETCH_ASSOC);
    }
    public function selectImage($userNo, $tournamentNo) {
        $stmt = " select main_image";
        $stmt .= "  from ms_tournament";
        $stmt .= " where user_no = ?";
        $stmt .= "   and tournament_no = ?";
        $res = $this->pdo->prepare($stmt);
        $res->execute(array($userNo, $tournamentNo));
        return $res->fetchColumn();
    }
    public function deleteTournament($userNo, $tournamentNo) {
        $stmt = " delete from ms_tournament";
        $stmt .= " where user_no = ?";
        $stmt .= "   and tournament_no = ?";
        $res = $this->pdo->prepare($stmt);
        $res->execute(array($userNo, $tournamentNo));
        if ($count = $res->rowCount()) {
            $res->closeCursor();
            $stmt = " delete from tr_entry";
            $stmt .= " where user_no = ?";
            $stmt .= "   and tournament_no = ?";
            $res = $this->pdo->prepare($stmt);
            $res->execute(array($userNo, $tournamentNo));
            $res->closeCursor();
            $stmt = " delete from tr_start";
            $stmt .= " where user_no = ?";
            $stmt .= "   and tournament_no = ?";
            $res = $this->pdo->prepare($stmt);
            $res->execute(array($userNo, $tournamentNo));
        }
        return $count;
    }
    public function updateTournament($dest, $original, $userNo, $tournamentNo) {
        $stmt = " update ms_tournament";
        $stmt .= "   set main_image = ?,";
        $stmt .= "       original_file_name = ?";
        $stmt .= " where user_no = ?";
        $stmt .= "   and tournament_no = ?";
        $res = $this->pdo->prepare($stmt);
        $res->execute(array($dest, $original, $userNo, $tournamentNo));
        return $res->rowCount();
    }
}
// EOF.