<?php
final class StartDao extends Dao {
    public function __construct() {
    }
    public function replaceStart($uid, $uno, $tno) {
        $stmt = " replace into tr_start";
        $stmt .= " select ?, entry_no, user_no, tournament_no, now()";
        $stmt .= "   from tr_entry";
        $stmt .= "  where user_no = ?";
        $stmt .= "    and tournament_no = ?";
        $res = $this->pdo->prepare($stmt);
        $res->execute(array($uid, $uno, $tno));
    }
    public function selectStart($uid, $uno, $tno) {
        $stmt = " select st.entry_no,";
        $stmt .= "       en.entry_image,";
        $stmt .= "       en.comment";
        $stmt .= "  from tr_start st";
        $stmt .= " inner join tr_entry en";
        $stmt .= "    on (en.user_no = ? and en.tournament_no = ? and en.entry_no = st.entry_no)";
        $stmt .= " where st.unique_id = ?";
        $stmt .= " order by rand()";
        $stmt .= " limit 2";
        $res = $this->pdo->prepare($stmt);
        $res->execute(array($uno, $tno, $uid));
        return $res->fetchAll(PDO::FETCH_ASSOC);
    }
    public function deleteStart($uid, $entryNo) {
        $stmt = " delete from tr_start";
        $stmt .= " where unique_id = ?";
        $stmt .= "   and entry_no = ?";
        $res = $this->pdo->prepare($stmt);
        $res->execute(array($uid, $entryNo));
    }
    public function clearStart($uid) {
        $stmt = " delete from tr_start";
        $stmt .= " where unique_id = ?";
        $res = $this->pdo->prepare($stmt);
        $res->execute(array($uid));
    }
}
// EOF.