<?php
/**
 * NameConfigureImpl.
 * @package magic.core
 * @subpackage config.impl
 */
/**
 * 各種の命名規則を設定する、デフォルトの実装クラスです.
 * <p>
 * このクラスは必要な時に{@link Controller}によってロードされます。
 * </p>
 * @package magic.core
 * @subpackage config.impl
 * @author T.Okumura
 * @version 1.0.0
 * @final
 */
final class NameConfigureImpl implements NameConfigure {
    /**
     * コンストラクタ.
     */
    public function __construct() {
    }
    /**
     * デフォルトでは、先頭が大文字のキャメルケースクラスを返します.
     * @see NameConfigure::getPhpFileNamingType()
     * @see UpperCamelCase
     */
    public function getPhpFileNamingType() {
        return new UpperCamelCase();
    }
    /**
     * デフォルトでは、小文字のスネークケースクラスを返します.
     * @see NameConfigure::getHtmlFileNamingType()
     * @see LowerSnakeCase
     */
    public function getHtmlFileNamingType() {
        return new LowerSnakeCase();
    }
    /**
     * デフォルトでは、先頭が大文字のキャメルケースクラスを返します.
     * @see NameConfigure::getClassNamingType()
     * @see UpperCamelCase
     */
    public function getClassNamingType() {
        return new UpperCamelCase();
    }
    /**
     * デフォルトでは、先頭が小文字のキャメルケースクラスを返します.
     * @see NameConfigure::getMethodNamingType()
     * @see LowerCamelCase
     */
    public function getMethodNamingType() {
        return new LowerCamelCase();
    }
    /**
     * デフォルトでは、小文字のスネークケースクラスを返します.
     * @see NameConfigure::getRequestNamingType()
     * @see LowerSnakeCase
     */
    public function getRequestNamingType() {
        return new LowerSnakeCase();
    }
}
// EOF.