<?php
/**
 * SystemMessage_en.
 * @package magic.core
 * @subpackage helper.message
 */
/**
 * フレームワークが使用するメッセージです.
 * <p>
 * これらのメッセージは、{@link MagicException}によって使用されます。<br/>
 * アプリケーション側のメッセージクラスは、必ずこのクラスまたは
 * {@link SystemMessage}を継承して作成するようにしてください。
 * </p>
 * @package magic.core
 * @subpackage helper.message
 * @author T.Okumura
 * @version 1.0.0
 */
class SystemMessage_en extends SystemMessage {
    /**
     * コンストラクタ.
     */
    public function __construct() {
    }
    // メッセージのキーです。
    /**
     * クラスパスが不正.
     * @staticvar string
     */
    const SYS001 = 'Illegal class path. [%s]';
    /**
     * クラスが継承されていない.
     * @staticvar string
     */
    const SYS002 = 'Must extend %s-class. [%s]';
    /**
     * インターフェイスが実装されていない.
     * @staticvar string
     */
    const SYS003 = 'Must implement %s-interface. [%s]';
    /**
     * クラスがロードできない.
     * @staticvar string
     */
    const SYS004 = 'Unable to load class. [%s]';
    /**
     * ファンクションのコールに失敗.
     * @staticvar string
     */
    const SYS005 = 'Method is not callable function. [%s]';
    /**
     * 戻り値が不正.
     * @staticvar string
     */
    const SYS006 = 'Must return %s. [%s]';
    /**
     * HTMLファイルのパスが不正.
     * @staticvar string
     */
    const SYS007 = 'HTML file is not found. [%s]';
    /**
     * メッセージの引数が不正.
     * @staticvar string
     */
    const SYS008 = 'Too few arguments ["%s" : %s] in %s class at code [%s].';
    /**
     * メッセージが見つからない.
     * @staticvar string
     */
    const SYS009 = 'Message code [%s] is undefined in %s class.';
    // 置換文字列も、このように設定できます。
    /**
     * 引数がない場合.
     * @staticvar string
     */
    const NOTHING = 'Empty arguments';
}
// EOF.