<?php
/**
 * ViewClassLoader.
 * @package magic.core
 * @subpackage internal.loader
 */
/**
 * Viewクラスのローダーです.
 * <p>
 * これは必ずコールされます。<br/>
 * アプリケーションには、最低一つ以上のViewクラスが存在しなければいけません。
 * </p>
 * @package magic.core
 * @subpackage internal.loader
 * @author T.Okumura
 * @version 1.0.0
 * @final
 */
final class ViewClassLoader {
    /**
     * コンストラクタ.
     */
    private function __construct() {
    }
    /**
     * Viewクラスをロードします.
     * <p>
     * ロードするクラス名にNULLが渡された場合、コールされたActionクラスと同じ
     * 名前で解決しようと試みます。<br/>
     * ActionクラスとViewクラスを1対1で作成するなら、
     * {@link ActionResult}への引数は省略できます。
     * </p>
     * @param string $className ロードするクラス名
     * @param NameConfigure $name 命名規則設定クラス
     * @param PathConfigure $path パス設定クラス
     * @param RouteConfigure $route URL解決設定クラス
     * @return View Viewクラスを継承したクラス
     * @throws MagicException クラスがロードできなかった時
     * @static
     */
    public static function load($className, NameConfigure $name, PathConfigure $path, RouteConfigure $route) {
        if (is_null($className)) {
            $className = $route->getActionName();
        }
        $className = $className . $path->getViewSuffix();
        $classPath = $path->getViewPath();
        $classFile = $name->getPhpFileNamingType()->apply($className) . '.php';
        if (!@include_once $classPath . $classFile) {
            throw new MagicException(MessageBehavior::getMessage('SYS001', $classPath . $classFile));
        }
        $className = $name->getClassNamingType()->apply($className);
        if (!class_exists($className, FALSE)) {
            throw new MagicException(MessageBehavior::getMessage('SYS004', $className));
        }
        $class = new $className();
        if ($class instanceof View) {
            return $class;
        }
        throw new MagicException(MessageBehavior::getMessage('SYS002', array('View', $className)));
    }
}
// EOF.
