<?php
/**
 * CramMd5.
 * @package magic.core
 * @subpackage tool.mail.auth
 */
/**
 * CRAM-MD5認証で使用するクラスです.
 * <p>
 * このクラスは必要な時に{@link SmtpMailer}によってロードされます。
 * </p>
 * @package magic.core
 * @subpackage tool.mail.auth
 * @author T.Okumura
 * @version 1.0.0
 * @final
 */
final class CramMd5 {
    /**
     * コンストラクタ.
     */
    private function __construct() {
    }
    /**
     * レスポンスを取得します.
     * @param string $user 接続ユーザー名
     * @param string $pass 接続パスワード
     * @param string $challenge チャレンジ
     * @return string レスポンス
     * @static
     */
    public static function getResponse($user, $pass, $challenge) {
        if (strlen($pass) > 64) {
            $pass = pack('H32', md5($pass));
        }
        if (strlen($pass) < 64) {
            $pass = str_pad($pass, 64, chr(0));
        }
        $kIpad = substr($pass, 0, 64) ^ str_repeat(chr(0x36), 64);
        $kOpad = substr($pass, 0, 64) ^ str_repeat(chr(0x5C), 64);
        return $user . ' ' . md5($kOpad . pack('H32', md5($kIpad . $challenge)));
    }
}
// EOF.