<?php
/**
 * StringUtil.
 * @package magic.core
 * @subpackage util
 */
/**
 * 文字列に関するユーティリティクラスです.
 * <p>
 * 文字列を操作するための機能を提供します。<br/>
 * このクラスはオーバーライドできません。不足分は、ユーザー独自のクラスを作成してください。
 * </p>
 * @package magic.core
 * @subpackage util
 * @author T.Okumura
 * @version 1.0.0
 * @final
 */
final class StringUtil {
    /**
     * コンストラクタ.
     */
    private function __construct() {
    }
    /**
     * <var>$haystack</var>の文字列シーケンスが、<var>$needle</var>で始まるかどうかを判定します.
     * @param string $haystack 全体の文字列
     * @param string $needle 接頭辞
     * @return bool 接頭辞で表わされる場合はTRUE
     * @static
     */
    public static function startWith($haystack, $needle) {
        return strpos($haystack, $needle) === 0;
    }
    /**
     * <var>$haystack</var>の文字列シーケンスが、<var>$needle</var>で終わるかどうかを判定します.
     * @param string $haystack 全体の文字列
     * @param string $needle 接尾辞
     * @return bool 接尾辞で表わされる場合はTRUE
     * @static
     */
    public static function endWith($haystack, $needle) {
        return strrpos($haystack, $needle) === strlen($haystack) - strlen($needle);
    }
    /**
     * 再帰的に文字エンコーディングを置換します.
     * <p>
     * 単一の文字列に対するエンコーディングは、mb_convert_encodingを使用してください。<br/>
     * <var>$fromEncoding</var>の指定方法は、mb_convert_encodingに準拠します。
     * </p>
     * @param array $parameters 変換する文字の配列
     * @param string $toEncoding 変換後の文字エンコーディング
     * @param string $fromEncoding 変換前の文字エンコーディング
     * @return array 変換後の文字列の配列
     * @static
     */
    public static function convertEncoding(array $parameters, $toEncoding, $fromEncoding) {
        foreach ($parameters as &$value) {
            if (is_array($value)) {
                $value = self::convertEncoding($value, $toEncoding, $fromEncoding);
            } else {
                $value = mb_convert_encoding($value, $toEncoding, $fromEncoding);
            }
        }
        return $parameters;
    }
    /**
     * 再帰的に文字列をトリミングします.
     * <p>
     * 単一の文字列に対するトリミングは、trimを使用してください。<br/>
     * <var>$charlist</var>の指定方法は、trimに準拠します。
     * </p>
     * @param array $parameters トリミングする文字の配列
     * @param string $charlist [optional] 除去したい文字列(オプション)
     * @return array トリミングされた文字の配列
     * @static
     */
    public static function trim(array $parameters, $charlist = NULL) {
        foreach ($parameters as $key => &$value) {
            if (is_array($value)) {
                $value = self::trim($value, $charlist);
            } else {
                $value = is_null($charlist) ? trim($value) : trim($value, $charlist);
            }
        }
        return $parameters;
    }
}
// EOF.