package jp.pigumer.test.session;

import java.io.IOException;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringUtils;

public class SessionServlet extends HttpServlet {

	@Override
	public void init(ServletConfig config) throws ServletException {
		super.init(config);
		config.getServletContext().setAttribute("name", "Session Test");
	}

	@Override
	protected void service(HttpServletRequest req, HttpServletResponse res)
			throws ServletException, IOException {
		HttpSession session = req.getSession(true);
		String method = req.getMethod();
		if ("post".equalsIgnoreCase(method)) {
			String key = req.getParameter("key");
			String value = req.getParameter("value");
			if (StringUtils.isNotEmpty(key)) {
				if (StringUtils.isNotEmpty(value)) {
					session.setAttribute(key, value);
				} else {
					session.removeAttribute(key);
				}
			}
		}
		req.getRequestDispatcher("/WEB-INF/jsp/session.jsp").forward(req, res);
	}
	
}
