<?php
/*
  $Id: new_products.php,v 1.4 2007/04/16 05:40:39 ryu Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
  
  modified for Koshoten.net2
  http://www.koshoten.net/
*/
?>
<!-- newProducts -->
<?php
  if (KN_CFG_NEW_PRODUCTS_COLUMN_DISPLAY == 'true') {
    if ( (!isset($new_products_category_id)) || ($new_products_category_id == '0') ) {
      $new_products_query = tep_db_query("select p.products_id, p.products_image, p.products_tax_class_id, if(s.status, s.specials_new_products_price, p.products_price) as products_price from " . TABLE_PRODUCTS . " p left join " . TABLE_SPECIALS . " s on p.products_id = s.products_id where products_status = '1' order by p.products_date_added desc limit " . KN_CFG_MAX_DISPLAY_NEW_PRODUCTS);
    } else {
      $new_products_query = tep_db_query("select distinct p.products_id, p.products_image, p.products_tax_class_id, if(s.status, s.specials_new_products_price, p.products_price) as products_price from " . TABLE_PRODUCTS . " p left join " . TABLE_SPECIALS . " s on p.products_id = s.products_id, " . TABLE_PRODUCTS_TO_CATEGORIES . " p2c, " . TABLE_CATEGORIES . " c where p.products_id = p2c.products_id and p2c.categories_id = c.categories_id and c.parent_id = '" . (int)$new_products_category_id . "' and p.products_status = '1' order by p.products_date_added desc limit " . KN_CFG_MAX_DISPLAY_NEW_PRODUCTS);
    }

    $num_products = tep_db_num_rows($new_products_query);
    if (0 < $num_products) {
      $cssid = 'newProductsBox';
      $contentbox_header = sprintf(TABLE_HEADING_NEW_PRODUCTS, strftime('%B'));

      $row = 0;
      $col = 0;
      $width = (int)(100 / KN_CFG_MAX_DISPLAY_NEW_PRODUCTS_PER_ROW) . '%';
      $contentbox_contents = array();

      while ($new_products = tep_db_fetch_array($new_products_query)) {
        $new_products_description_query = tep_db_query("select products_name, products_subtitle, products_series_title, products_author, products_published, products_volume, products_publishers ,products_description from " . TABLE_PRODUCTS_DESCRIPTION . " where products_id = '" . (int)$new_products['products_id'] . "' and language_id = '" . (int)$languages_id . "'");
        $new_products_description = tep_db_fetch_array($new_products_description_query);
        $new_products_list = '<h4><a href="' . tep_href_link(FILENAME_PRODUCT_INFO, 'products_id=' . $new_products['products_id']) . '"><span class="pName">' . $new_products_description['products_name'] . '</span></a>' . 
                                               (KN_CFG_USE_SUBTITLE == 'true' ? ' <span class="pSubtitle">' . $new_products_description['products_subtitle'] . '</span>' : '') . 
                                               (KN_CFG_USE_SERIES_TITLE == 'true' ? ' <span class="pSeriesTitle">' . $new_products_description['products_series_title'] . '</span>' : '') . "</h4>\n";
        if ($new_products['products_image']) {
          $new_products_list .= '<p class="pImage"><a href="' . tep_href_link(FILENAME_PRODUCT_INFO, 'products_id=' . $new_products['products_id']) . '">' . tep_image(DIR_WS_IMAGES . $new_products['products_image'], $new_products_description['products_name'], SMALL_IMAGE_WIDTH, SMALL_IMAGE_HEIGHT) . '</a></p>' . "\n";
        }
        $new_products_list .= "<ul>\n" . 
                                    ((KN_CFG_USE_AUTHOR == 'true') && ($new_products_description['products_author']) ? '<li class="pAuthor">' . $new_products_description['products_author'] . "</li>\n" : '') . 
                                    ((KN_CFG_USE_PUBLISHERS == 'true') && ($new_products_description['products_publishers']) ? '<li class="pPublishers">' . $new_products_description['products_publishers'] . "</li>\n" : '') . 
                                    ((KN_CFG_USE_VOLUME == 'true') && ($new_products_description['products_volume']) ? '<li class="pVolume">' . $new_products_description['products_volume'] . "</li>\n" : '') . 
                                    ((KN_CFG_USE_PUBLISHED == 'true') && ($new_products_description['products_published']) ? '<li class="pPublished">' . $new_products_description['products_published'] . "</li>\n" : '') .
                                    '<li class="pDescription">' . $new_products_description['products_description'] . "</li>\n" . 
                                    "</ul>\n" .
                                    '<p class="pPrice">' .  ((KN_CFG_CONTACT_PRICE != 0) && ($new_products['products_price'] == KN_CFG_CONTACT_PRICE) ? '' : $currencies->display_price($new_products['products_price'], tep_get_tax_rate($new_products['products_tax_class_id']))) . "</p>\n";
        $contentbox_contents[$row][$col] = array('params' => 'width="' . $width . '"',
                                                           'text' => $new_products_list);
        $col ++;
        if ($col == KN_CFG_MAX_DISPLAY_NEW_PRODUCTS_PER_ROW) {
          $col = 0;
          $row ++;
        }
      }
      new contentBox($cssid, $contentbox_contents, $contentbox_header);
    }
  }
?>
<!-- /newProducts -->
