<?php
/*
  $Id: ot_shipping.php,v 1.1.1.1 2005/06/30 05:04:20 ryu Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
*/

  class ot_shipping {
    var $title, $output;

    function ot_shipping() {
      $this->code = 'ot_shipping';
      $this->title = MODULE_ORDER_TOTAL_SHIPPING_TITLE;
      $this->description = MODULE_ORDER_TOTAL_SHIPPING_DESCRIPTION;
      $this->enabled = ((MODULE_ORDER_TOTAL_SHIPPING_STATUS == 'true') ? true : false);
      $this->sort_order = MODULE_ORDER_TOTAL_SHIPPING_SORT_ORDER;

      $this->output = array();
    }

    function process() {
      global $order, $currencies;

      if (MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING == 'true') {
        switch (MODULE_ORDER_TOTAL_SHIPPING_DESTINATION) {
          case 'national':
            if ($order->delivery['country_id'] == STORE_COUNTRY) $pass = true; break;
          case 'international':
            if ($order->delivery['country_id'] != STORE_COUNTRY) $pass = true; break;
          case 'both':
            $pass = true; break;
          default:
            $pass = false; break;
        }

        if ( ($pass == true) && ($order->info['subtotal'] >= MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER) ) {
          $order->info['shipping_method'] = $this->title;
          $order->info['total'] -= $order->info['shipping_cost'];
          $order->info['shipping_cost'] = 0;
        }
      }

      $module = substr($GLOBALS['shipping']['id'], 0, strpos($GLOBALS['shipping']['id'], '_'));

      if (tep_not_null($order->info['shipping_method'])) {
        if ($GLOBALS[$module]->tax_class > 0) {
          $shipping_tax = tep_get_tax_rate($GLOBALS[$module]->tax_class, $order->delivery['country']['id'], $order->delivery['zone_id']);
          $shipping_tax_description = tep_get_tax_description($GLOBALS[$module]->tax_class, $order->delivery['country']['id'], $order->delivery['zone_id']);

          $tax_val = tep_calculate_tax($order->info['shipping_cost'], $shipping_tax);
          $order->info['tax']                                     += $tax_val;
          $order->info['tax_groups']["$shipping_tax_description"] += $tax_val;
          $order->info['total']                                   += $tax_val;

          if (DISPLAY_PRICE_WITH_TAX == 'true') $order->info['shipping_cost'] += $tax_val;
        }

        $this->output[] = array('title' => $order->info['shipping_method'] . ':',
                                'text'  => $currencies->format($order->info['shipping_cost'], true, $order->info['currency'], $order->info['currency_value']),
                                'value' => $order->info['shipping_cost']);
// BOF koshoten.net-2.0.0
      // ʰǼб
      } else {
        if (KN_CFG_SHORT_CHECKOUT == 'true') {
// BOF koshoten.net-2.0.1
/*
          $order->info['shipping_method'] = $this->title . MODULE_SHIPPING_SHORT_TEXT_GET_QUOTE_LATER;
*/
          $order->info['shipping_method'] = $this->title;
// EOF koshoten.net-2.0.1
          $order->info['total'] -= $order->info['shipping_cost'];
          $order->info['shipping_cost'] = 0;
        }
        
        $this->output[] = array('title' => $order->info['shipping_method'] . ':',
// BOF koshoten.net-2.0.1
/*
                                'text'  => $currencies->format($order->info['shipping_cost'], true, $order->info['currency'], $order->info['currency_value']),
*/
                                'text'  => MODULE_SHIPPING_SHORT_TEXT_GET_QUOTE_LATER,
// EOF koshoten.net-2.0.1
                                'value' => $order->info['shipping_cost']);
// EOF koshoten.net-2.0.0
      }
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_ORDER_TOTAL_SHIPPING_STATUS'");
        $this->_check = tep_db_num_rows($check_query);
      }

      return $this->_check;
    }

    function keys() {
      return array('MODULE_ORDER_TOTAL_SHIPPING_STATUS', 'MODULE_ORDER_TOTAL_SHIPPING_SORT_ORDER', 'MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING', 'MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER', 'MODULE_ORDER_TOTAL_SHIPPING_DESTINATION');
    }

    function install() {
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('ɽ', 'MODULE_ORDER_TOTAL_SHIPPING_STATUS', 'true', 'ɽ򤷤ޤ?', '6', '1','tep_cfg_select_option(array(\'true\', \'false\'), ', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('ɽ', 'MODULE_ORDER_TOTAL_SHIPPING_SORT_ORDER', '2', 'ɽǤޤ. ۤɾ̤ɽޤ.', '6', '2', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('̵', 'MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING', 'false', '̵ͭˤޤ?', '6', '3', 'tep_cfg_select_option(array(\'true\', \'false\'), ', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, date_added) values ('̵ˤ', 'MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER', '5000', '۰ʾ򤴹ξ̵ˤޤ.', '6', '4', 'currencies->format', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('̵ŬѤϰ', 'MODULE_ORDER_TOTAL_SHIPPING_DESTINATION', 'national', 'ꤷϰФ̵ŬѤޤ.', '6', '5', 'tep_cfg_select_option(array(\'national\', \'international\', \'both\'), ', now())");
    }

    function remove() {
      tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }
  }
?>