<?php
/*
  $Id: recommendation.php,v 1.5 2009/04/08 17:39:19 tane Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
  
  modified for Koshoten.net2
  http://www.koshoten.net/
*/
?>
<!-- recommendation -->
<?php

  if (KN_CFG_RECOMMENDATION_COLUMN_DISPLAY == 'true') {
    if ((!isset($recommended_products_category_id)) || ($recommended_products_category_id == '0')) {
      $recommended_query = tep_db_query("select p.products_id, p.products_image, p.products_tax_class_id, if(s.status, s.specials_new_products_price, p.products_price) as products_price, pd.products_name, pd.products_subtitle, pd.products_series_title, pd.products_author, pd.products_published, pd.products_volume, pd.products_publishers, pd.products_description, pd.products_description2 from (" . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_DESCRIPTION . " pd) left join " . TABLE_SPECIALS . " s on p.products_id = s.products_id where p.products_status = '1' and p.products_id = pd.products_id and pd.language_id = '" . (int)$languages_id . "' and p.recommendation_order > 0 order by p.recommendation_order limit " . KN_CFG_MAX_DISPLAY_RECOMMENDATION);
    } else {
      $recommended_query = tep_db_query("select distinct p.products_id, p.products_image, p.products_tax_class_id, if(s.status, s.specials_new_products_price, p.products_price) as products_price,pd.products_name, pd.products_subtitle, pd.products_series_title, pd.products_author, pd.products_published, pd.products_volume, pd.products_publishers, pd.products_description, pd.products_description2  from (" . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_DESCRIPTION . " pd) left join " . TABLE_SPECIALS . " s on p.products_id = s.products_id, " . TABLE_PRODUCTS_TO_CATEGORIES . " p2c, " . TABLE_CATEGORIES . " c where p.products_id = p2c.products_id and p.products_id = pd.products_id and p2c.categories_id = c.categories_id and c.parent_id = '" . (int)$recommended_products_category_id . "' and p.products_status = '1' and pd.language_id = '" . (int)$languages_id . "' and p.recommendation_order > 0 order by p.recommendation_order limit " . KN_CFG_MAX_DISPLAY_RECOMMENDATION);
    }

    $num_products = tep_db_num_rows($recommended_query);
    if (0 < $num_products) {
      $cssid = 'recommendationBox';
      $contentbox_header = TABLE_HEADING_RECOMMENDATION;

      $row = 0;
      $col = 0;
      $width = (int)(100 / KN_CFG_MAX_DISPLAY_RECOMMENDATION_PER_ROW) . '%';
      $contentbox_contents = array();
      while ($recommended = tep_db_fetch_array($recommended_query)) {
        $recommended_products_list = '<h4><a href="' . tep_href_link(FILENAME_PRODUCT_INFO, 'products_id=' . $recommended['products_id']) . '"><span class="pName">' . $recommended['products_name'] . '</span></a>' . 
                                               (KN_CFG_USE_SUBTITLE == 'true' ? ' <span class="pSubtitle">' . $recommended['products_subtitle'] . '</span>' : '') . 
                                               (KN_CFG_USE_SERIES_TITLE == 'true' ? ' <span class="pSeriesTitle">' . $recommended['products_series_title'] . '</span>' : '') . "</h4>\n";
        if ($recommended['products_image']) {
        	$recommended_products_list .= '<p class="pImage"><a href="' . tep_href_link(FILENAME_PRODUCT_INFO, 'products_id=' . $recommended['products_id']) . '">' . tep_image(DIR_WS_IMAGES . $recommended['products_image'], $recommended['products_name'], SMALL_IMAGE_WIDTH, SMALL_IMAGE_HEIGHT) . '</a></p>' . "\n";
        }
        $recommended_products_list .= "<ul>\n" .
                                               ((KN_CFG_USE_AUTHOR == 'true') && ($recommended['products_author']) ? '<li class="pAuthor">' . $recommended['products_author'] . "</li>\n" : '') . 
                                               ((KN_CFG_USE_PUBLISHERS == 'true') && ($recommended['products_publishers']) ? '<li class="pPublishers">' . $recommended['products_publishers'] . "</li>\n" : '') . 
                                               ((KN_CFG_USE_VOLUME == 'true') && ($recommended['products_volume']) ? '<li class="pVolume">' . $recommended['products_volume'] . "</li>\n" : '') . 
                                               ((KN_CFG_USE_PUBLISHED == 'true') && ($recommended['products_published']) ? '<li class="pPublished">' . $recommended['products_published'] . "</li>\n" : '') . 
                                               '<li class="pDescription">' . $recommended['products_description'] . "</li>\n" . 
                                               "</ul>\n" .
                                               '<p class="pPrice">' . ((KN_CFG_CONTACT_PRICE != 0) && ($recommended['products_price'] == KN_CFG_CONTACT_PRICE) ? KN_CFG_CONTACT_PRICE_TEXT : $currencies->display_price($recommended['products_price'], tep_get_tax_rate($recommended['products_tax_class_id']))) . "</p>\n" . 
                                               ((KN_CFG_USE_DESCRIPTION2 == 'true') && (KN_CFG_RECOMMENDATION_DESCRIPTION2_DISPLAY == 'true') ? '<p class="pDescription2">' . nl2br($recommended['products_description2']) . "</p>\n" : '');
        $contentbox_contents[$row][$col] = array('params' => 'width="' . $width . '"',
                                                         'text' => $recommended_products_list);
        $col ++;
        if ($col == KN_CFG_MAX_DISPLAY_RECOMMENDATION_PER_ROW) {
          $col = 0;
          $row ++;
        }
      }

      new contentBox($cssid, $contentbox_contents, $contentbox_header);
    }
  }
?>
<!-- /recommendation -->
