<?php
  /*
   * GETA用設定ファイル
   * vim:ts=2:sw=2:sts=2:expandtab
   */
  
  /* start of configuration */

  // adminディレクトリのパス eg.) '/var/www/koshoten/admin'
  define('ADMIN_PATH', '/var/www/koshoten/admin');

  // 連想検索にカテゴリー・追加情報・書評を含めるか？ true/false
  define('INCLUDE_CATEGORIES', true);
  define('INCLUDE_MANUFACTURES', false);
  define('INCLUDE_REVIEWS', false);

  // 追加分類名（使用していない場合は''）
  define('KN_CFG_USE_MANUFACTURERS', '');

  // TODO: DBから取得する
  define('KN_CFG_USE_SUBTITLE', true);
  define('KN_CFG_USE_SERIES_TITLE', true);
  define('KN_CFG_USE_AUTHOR', true);
  define('KN_CFG_USE_PUBLISHERS', true);
  define('KN_CFG_USE_VOLUME', true);
  define('KN_CFG_USE_PUBLISHED', true);

  /* end of configuration */

  define('STORE_DB_TRANSACTIONS', false);
  define('TEXT_PRODUCTS_NAME', '書名');
  define('TEXT_PRODUCTS_SUBTITLE', '副題');
  define('TEXT_PRODUCTS_SERIES_TITLE', 'シリーズ名');
  define('TEXT_PRODUCTS_AUTHOR', '著者');
  define('TEXT_PRODUCTS_PUBLISHERS', '出版元');
  define('TEXT_PRODUCTS_DESCRIPTION', '説明文');
  define('TEXT_PRODUCTS_DESCRIPTION2', '説明文２');
  define('TEXT_PRODUCTS_KEYWORDS', '検索キーワード');
  define('TEXT_CATEGORIES_NAME', 'カテゴリー名');
  define('TEXT_CATEGORIES_DESCRIPTION', '説明文');
  define('TEXT_CATEGORIES_KEYWORDS', 'カテゴリーの検索キーワード');
  define('TEXT_MANUFACTURERS_NAME', KN_CFG_USE_MANUFACTURERS . '名');
  define('TEXT_MANUFACTURERS_KEYWORDS', KN_CFG_USE_MANUFACTURERS . 'の検索キーワード');
  define('TEXT_REVIEWS_TEXT', '書評内容');

  error_reporting(E_ALL & ~E_NOTICE);
  chdir(ADMIN_PATH);
  
  mb_internal_encoding('euc-jp');
  mb_regex_encoding('euc-jp');
  $languages_id = 4;
  require('includes/configure.php');
  require(DIR_WS_FUNCTIONS . 'database.php');
  tep_db_connect() or die('Unable to connect to database server!');

  require('../geta_work/geta_cfg.php');

  /**
   * 連想検索設定ファイルを読み込む
   */
  function read_config($filename, $fields_array){
    $cfg_file = @fopen($filename, 'r');
    if ($cfg_file) {
      while (!feof($cfg_file)) {
        $cfg_rec = fgetcsv($cfg_file,200);
        // 空白行は読み飛ばす
        if (empty($cfg_rec)) { continue; }

        foreach ($fields_array as &$field_array) {
          if ($cfg_rec[0] == $field_array['field']) {
            $field_array['check']  = (int)$cfg_rec[1];
            $field_array['weight'] = (int)$cfg_rec[2];
          }
        }
      }
    }
    fclose($cfg_file);
    return;
  }

  /**
   * weight値に応じてデータを付加する
   */
  function append_weight(&$product_contents, $fields_array, $query_string){
    foreach ($fields_array as $field_array) {
      if (!empty($field_array['field']) && $field_array['check'] > 0) {
        $query = tep_db_query($query_string); 
        while ($row = tep_db_fetch_array($query)) {
          // データの抽出（重みの分だけ繰り返す）
          foreach (array(1, $field_array['weight']) as $j) {
            $product_contents .= ' ' . $row[$field_array['field']];
          }
        }
      }
    }
  }

  // 設定ファイルの読み込み
  read_config(FILENAME_C_MAKEWAM_CONFIG, $mw_categories_field);
  read_config(FILENAME_P_MAKEWAM_CONFIG, $mw_products_field);
  read_config(FILENAME_M_MAKEWAM_CONFIG, $mw_manufacturers_field);
  read_config(FILENAME_R_MAKEWAM_CONFIG, $mw_reviews_field);

  // 商品WAMの生成
  // 形態素分析するデータとタイトルファイルの作成
  $indata = fopen(FILENAME_P_INDATA, "w");
  $titledata = fopen(FILENAME_P_T_INFILE, "w");
  $products_query = tep_db_query("
      select p.products_id, p.products_model, p.products_image, p.products_isbn, p.products_price, 
      p.manufacturers_id, p.products_tax_class_id, IF(s.status, s.specials_new_products_price, NULL) as specials_new_products_price, 
      pd.products_name, pd.products_subtitle, pd.products_series_title, pd.products_author, pd.products_publishers, 
      pd.products_published, pd.products_volume, pd.products_description, pd.products_description2, pd.products_keywords 
      from (products p, products_description pd) 
      left join specials s on p.products_id = s.products_id 
      where p.products_status = '1' and pd.products_id = p.products_id and pd.language_id = '" . $languages_id . "'");
  while ($products = tep_db_fetch_array($products_query)) {
    $product_contents_id = "<::" . $products['products_id'] . "::>";
    $product_contents = "";

    foreach ($mw_products_field as $field_array) {
      if (!empty($field_array['field']) && $field_array['check'] > 0) {
          // データの抽出（重みの分だけ繰り返す）
          foreach (range(1, $field_array['weight']) as $j) {
            $product_contents .= ' ' . $products[$field_array['field']];
          }
      }
    }
    // カテゴリー情報も含める場合
    if (INCLUDE_CATEGORIES) {
      $products_id = $products['products_id'];
      $categories_query = "select cd.categories_name, cd.categories_description, cd.categories_keywords 
          from products_to_categories p2c, categories_description cd 
          where p2c.products_id = '" . $products_id . "' 
          and p2c.categories_id = cd.categories_id and cd.language_id='" . $languages_id . "'";
      append_weight($product_contents, $mw_categories_field, $categories_query); 
    }
    if (INCLUDE_MANUFACTURES) {
      // 追加分類情報も含める場合
      $manufacturers_id = $products['manufacturers_id'];
      $manufacturers_query = "select m.manufacturers_name, mf.manufacturers_keywords 
          from manufacturers m, manufacturers_info mf 
          where m.manufacturers_id = '" . $manufacturers_id . "' and m.manufacturers_id = mf.manufacturers_id 
          and mf.languages_id = '" . $languages_id . "'";
      append_weight($product_contents, $mw_manufacturers_field, $manufacturers_query); 
    }
    if (INCLUDE_REVIEWS) {
      // 書評情報も含める場合
      $reviews_products_id = $products['products_id'];
      $reviews_query = "select rd.reviews_text from reviews r, reviews_description rd 
          where r.products_id = '" . $reviews_products_id . "' and r.reviews_id = rd.reviews_id 
          and rd.languages_id = '" . $languages_id . "'";
      append_weight($product_contents, $mw_reviews_field, $reviews_query); 
    }

    $product_contents = preg_replace("/(\r\n|\r|\n)/", "", $product_contents);
    $product_contents = mb_convert_kana($product_contents, "AsK");
    $product_contents = mb_ereg_replace("[" . $replace_symbol . "]", " ", $product_contents);
    foreach ($replace_array as $value) {
      if ($value) $product_contents = mb_ereg_replace("[" . $value . "]", " ", $product_contents);
    }
    fwrite($indata, $product_contents_id . $product_contents . "\n");
    // タイトルファイルの作成
    fwrite($titledata, "%" . $products['products_id'] . "\n");
     
    $title_contents = ' products_name<>' . $products['products_name'] . ',';
    if (KN_CFG_USE_SUBTITLE == 'true') {
      $title_contents .= 'products_subtitle<>' . $products['products_subtitle'] . ',';
    }
    if (KN_CFG_USE_SERIES_TITLE == 'true') {
      $title_contents .= 'products_series_title<>' . $products['products_series_title'] . ',';
    }
    if (KN_CFG_USE_AUTHOR == 'true') {
      $title_contents .= 'products_author<>' . $products['products_author'] . ',';
    }
    $title_contents .= 'products_description<>' . $products['products_description'] . ',';
    if (KN_CFG_USE_PUBLISHERS == 'true') {
      $title_contents .= 'products_publishers<>' . $products['products_publishers'] . ',';
    }
    if (KN_CFG_USE_VOLUME == 'true') {
      $title_contents .= 'products_volume<>' . $products['products_volume'] . ',';
    }
    if (KN_CFG_USE_PUBLISHED == 'true') {
      $title_contents .= 'products_published<>' . $products['products_published'] . ',';
    }
    $title_contents .= 'products_price<>' . $products['products_price'] . ',';
    $title_contents .= 'products_tax_class_id<>' . $products['products_tax_class_id'] . ',';
    $title_contents .= 'specials_new_products_price<>' . $products['specials_new_products_price'] . ',';
    $title_contents .= 'products_model<>' . $products['products_model'] . ',';
    $title_contents .= 'products_isbn<>' . $products['products_isbn'] . ',';
    $title_contents .= 'products_image<>' . $products['products_image'];
    $title_contents = preg_replace("/(\r\n|\r|\n)/", "", $title_contents);
    fwrite($titledata, $title_contents . "\n");
  }
  fclose($indata);
  fclose($titledata);
    
  // 形態素分析の実行＆頻度ファイルの作成
  exec(FILENAME_MAKEWAM_JP . ' ' . DIR_FS_GETA_WORK . ' ' . FILENAME_P_INDATA . ' ' . FILENAME_P_FREQFILE);
  // WAMの生成
  exec(FILENAME_MKW . ' ' . TEXT_P_HANDLE_ID . ' ' . DIR_FS_GETA_WORK . ' ' . FILENAME_P_FREQFILE);
  exec(FILENAME_MKAUX . ' ' . TEXT_P_HANDLE_ID . ' ' . DIR_FS_GETA_WORK . ' ' . FILENAME_P_T_INFILE);

?>
