<?php
/*
  $Id: _yuupack.php,v 1.2 2006/01/29 14:49:23 ryu Exp $

  YuuPack Shipping Calculator.
  Calculate shipping costs.

  2002/04/23 written by TAMURA Toshihiko (tamura@bitscope.co.jp)
  2003/04/12 modified for ms1
  2004/09/30 б
 */
/*
  $rate = new _YuuPack('yuupack','椦ѥå');
  $rate->SetOrigin('01', 'JP');  // ̳ƻ
  $rate->SetDest('13', 'JP');    // Ԥޤ
  $rate->SetWeight(10);          // (kg)ޤ(l)
  $rate->SetSizeTable($size_table);// Ȥν/Ѥ
  $quote = $rate->GetQuote();
  print $quote['type'] . "<br>";
  print $quote['cost'] . "\n";
*/
class _YuuPack {
    var $quote;
    var $OriginZone;
    var $OriginCountryCode = 'JP';
    var $DestZone;
    var $DestCountryCode = 'JP';
    var $Weight = 0;
    var $Length = 0;
    var $Width  = 0;
    var $Height = 0;
    var $SizeList;      // 60170 Υꥹ(շ)
    var $SizeTable;     // index,շ(cmޤ),(kgޤ)
    var $MaxWeight = 0; // (kg):0ʤ̵
    var $Items = 1;     // 
    var $Mode;          // 'weight'/'volume'

    // 󥹥ȥ饯
    // $id:   module id
    // $titl: module name
    // $zone: ƻܸ '01''47'
    // $country: country code
    function _YuuPack($id, $title, $zone = NULL, $country = NULL) {
      $this->quote = array('id' => $id, 'title' => $title);
      if($zone) {
        $this->SetOrigin($zone, $country);
      }
      $this->SizeList = array(60,80,100,120,140,160,170);
      $this->SizeTable = array();
      $this->Mode = MODULE_SHIPPING_YUUPACK_MODE; // 'weight'/'volume'
    }
    // ȯ򥻥åȤ
    // $zone: ƻܸ '01''47'
    // $country: country code
    function SetOrigin($zone, $country = NULL) {
      $this->OriginZone = $zone;
      if($country) {
        $this->OriginCountryCode = $country;
      }
    }
    function SetDest($zone, $country = NULL) {
      $this->DestZone = $zone;
      if($country) {
        $this->DestCountryCode = $country;
      }
    }
    function SetMaxWeight($weight) {
      $this->MaxWeight = $weight;
    }
    function SetWeight($weight) {
      $this->Weight = $weight;
    }
    function SetSize($length = NULL, $width = NULL, $height = NULL) {
      if($length) {
        $this->Length = $length;
      }
      if($width) {
        $this->Width = $width;
      }
      if($height) {
        $this->Height = $height;
      }
    }
    // Ȥν/Ѥ¤Ͽ
    // $a_size_table : array(60=>w1, 80->w2,...)
    //
    function SetSizeTable($a_size_table) {
      $i = 0;
      $this->SizeTable = array();
      foreach ($this->SizeList as $size) {
        $weight = isset($a_size_table[$size]) ? $a_size_table[$size] : 0;
        $this->SizeTable[] = array($i++, $size, $weight);
      }
    }
    // 1ѥå˼̤ޤѤ֤
    function GetWeightLimut() {
      $limit = 0;
      foreach ($this->SizeTable as $a_size) {
        $limit = max($limit, $a_size[2]);
      }
      if ( 0 < $this->MaxWeight ) {
        $limit = min($this->MaxWeight, $limit);
      }
      return $limit;
    }
    // ʬ(06)֤
    // ʳξ-1֤
    //
    // ʬ շ    
    // ---------------------------------
    // 0     60cmޤ ?kgޤ
    // 1     80cmޤ ?kgޤ
    // 2    100cmޤ ?kgޤ
    // 3    120cmޤ ?kgޤ
    // 4    140cmޤ ?kgޤ
    // 5    160cmޤ ?kgޤ
    // 6    170cmޤ ?kgޤ
    //
    function GetSizeClass($weight) {
      foreach ($this->SizeTable as $a_limit) {
        // $a_limit : array(index,շ,)
        if ($weight <= $a_limit[2]) {
          return $a_limit[0];
        }
      }
      return -1;  // ʳ
    }
    // ȤξϿ
    //
    function SetItems($items) {
      $this->Items = max($items, 1);
    }
    // ո褫饭
    //
    function GetDistKey() {
        $s_key = '';
        $s_z1 = $this->GetLZone($this->OriginZone);
        $s_z2 = $this->GetLZone($this->DestZone);
        if ( $s_z1 && $s_z2 ) {
            // ӥɤ򥢥ե٥åȽϢ뤹
            $s_key = (ord($s_z1) < ord($s_z2)) ? ($s_z1 . $s_z2) : ($s_z2 . $s_z1);
        }
        return $s_key;
    }
    // ƻܸɤӥɤ
    // $zone: ƻܸ
    function GetLZone($zone) {
        // ƻܸɤӥ('A''K')Ѵ
        // ̳ƻ:'A' = ̳ƻ
        //   :'B' = Ŀ,긩,ĸ,ܾ븩,,ʡ縩
        //   :'C' = 븩,ڸ,ϸ,̸,ո,,,
        //   :'D' = 㸩,Ĺ
        // Φ  :'E' = ٻ,,ʡ温
        // 쳤  :'F' = 츩,Ų,θ,Ÿ
        // ᵦ  :'G' = 츩,,,ʼ˸,ɸ,²λ
        //   :'H' = Ļ踩,纬,,縩,
        // ͹  :'I' = 縩,,ɲ,θ
        // 彣  :'J' = ʡ,츩,Ĺ긩,ʬ,ܸ,ܺ긩,縩
        //   :'K' = 츩
        $a_zonemap = array(
        '01'=>'A',  // ̳ƻ
        '02'=>'B',  // Ŀ
        '03'=>'B',  // 긩
        '04'=>'B',  // ܾ븩
        '05'=>'B',  // ĸ
        '06'=>'B',  // 
        '07'=>'B',  // ʡ縩
        '08'=>'C',  // 븩
        '09'=>'C',  // ڸ
        '10'=>'C',  // ϸ
        '11'=>'C',  // ̸
        '12'=>'C',  // ո
        '13'=>'C',  // 
        '14'=>'C',  // 
        '15'=>'D',  // 㸩
        '16'=>'E',  // ٻ
        '17'=>'E',  // 
        '18'=>'E',  // ʡ温
        '19'=>'C',  // 
        '20'=>'D',  // Ĺ
        '21'=>'F',  // 츩
        '22'=>'F',  // Ų
        '23'=>'F',  // θ
        '24'=>'F',  // Ÿ
        '25'=>'G',  // 츩
        '26'=>'G',  // 
        '27'=>'G',  // 
        '28'=>'G',  // ʼ˸
        '29'=>'G',  // ɸ
        '30'=>'G',  // ²λ
        '31'=>'H',  // Ļ踩
        '32'=>'H',  // 纬
        '33'=>'H',  // 
        '34'=>'H',  // 縩
        '35'=>'H',  // 
        '36'=>'I',  // 縩
        '37'=>'I',  // 
        '38'=>'I',  // ɲ
        '39'=>'I',  // θ
        '40'=>'J',  // ʡ
        '41'=>'J',  // 츩
        '42'=>'J',  // Ĺ긩
        '43'=>'J',  // ܸ
        '44'=>'J',  // ʬ
        '45'=>'J',  // ܺ긩
        '46'=>'J',  // 縩
        '47'=>'K'   // 츩
        );
        return $a_zonemap[$zone];
    }

    function GetQuote() {
        // ӡ̤β:  => (60,80,100,120,140,160,170)
        $a_pricerank = array(
        'N0'=>array( 600, 800,1000,1200,1400,1600,1700), // 
        'N1'=>array( 700, 900,1100,1300,1500,1700,1900), // 1 Υ
        'N2'=>array( 800,1000,1200,1400,1600,1800,2000), // 2   
        'N3'=>array( 900,1100,1300,1500,1700,1900,2100), // 3
        'N4'=>array(1000,1200,1400,1600,1800,2000,2200), // 4
        'N5'=>array(1100,1300,1500,1700,1900,2100,2300), // 5
        'N6'=>array(1200,1400,1600,1800,2000,2200,2400), // 6   
        'N7'=>array(1300,1500,1700,1900,2100,2300,2500), // 7 Υ
        );
        // Ӵ֤βʥ
        // () http://www.japanpost.jp/pressrelease/japanese/yubin/040929j201.html
        $a_dist_to_rank = array(
        'AA'=>'N0',
        'AB'=>'N2','BB'=>'N1',
        'AC'=>'N4','BC'=>'N1','CC'=>'N1',
        'AD'=>'N4','BD'=>'N1','CD'=>'N1','DD'=>'N1',
        'AE'=>'N5','BE'=>'N2','CE'=>'N1','DE'=>'N1','EE'=>'N1',
        'AF'=>'N5','BF'=>'N2','CF'=>'N1','DF'=>'N1','EF'=>'N1','FF'=>'N1',
        'AG'=>'N6','BG'=>'N3','CG'=>'N2','DG'=>'N2','EG'=>'N1','FG'=>'N1','GG'=>'N1',
        'AH'=>'N7','BH'=>'N4','CH'=>'N3','DH'=>'N3','EH'=>'N2','FH'=>'N2','GH'=>'N1','HH'=>'N1',
        'AI'=>'N7','BI'=>'N4','CI'=>'N3','DI'=>'N3','EI'=>'N2','FI'=>'N2','GI'=>'N1','HI'=>'N1','II'=>'N1',
        'AJ'=>'N7','BJ'=>'N6','CJ'=>'N5','DJ'=>'N5','EJ'=>'N3','FJ'=>'N3','GJ'=>'N2','HJ'=>'N1','IJ'=>'N2','JJ'=>'N1',
        'AK'=>'N7','BK'=>'N7','CK'=>'N6','DK'=>'N7','EK'=>'N7','FK'=>'N6','GK'=>'N6','HK'=>'N5','IK'=>'N6','JK'=>'N3','KK'=>'N0',
        );

        $s_key = $this->GetDistKey();          // 'AB'ʤɤӥ
        if ( $s_key ) {
            if ( ($this->OriginCountryCode == $this->DestCountryCode)
                 && ($this->OriginZone == $this->DestZone)
                 && $this->OriginZone
               ) {
                $s_rank = 'N0';                    // 
            } else {
                $s_rank = $a_dist_to_rank[$s_key]; // 'N1'ʤɤΥ󥯤
            }

            if ( $s_rank ) {
                // 1ѥå˼̤ޤ
                $limit = $this->GetWeightLimut();
                if ($limit < 0.1) {
                    $this->quote['error'] = MODULE_SHIPPING_YUUPACK_TEXT_CONFIG_ERROR;
                } elseif ( ($boxes = $this->GetBoxes($this->Weight, $limit)) < 1 ) {
                    $this->quote['error'] = MODULE_SHIPPING_YUUPACK_TEXT_OVERSIZE;
                } else {
                    $this->quote['boxes'] = $boxes;

                    // ;͵Ψ
                    $room_ratio = ($this->Mode == 'volume' && $boxes < $this->Items)
                          ? max(1.0,MODULE_SHIPPING_YUUPACK_ROOM) : 1.0;

                    // ׻Ѥ̤ޤ(1)
                    $wv = $this->Weight / $boxes * $room_ratio;

                    // 06 Υ饹
                    $n_sizeclass = $this->GetSizeClass($wv);
                    if ($n_sizeclass < 0) {
                        $this->quote['error'] = MODULE_SHIPPING_YUUPACK_TEXT_OVERSIZE;
                    } else {
                        $this->quote['cost'] = $a_pricerank[$s_rank][$n_sizeclass] * $boxes;
                        $this->quote['wv'] = $wv;
                    }
                }
            //  $this->quote['DEBUG'] = ' zone='.$this->OriginZone.'-'.$this->DestZone //DEBUG
            //  . ' cost=' . $a_pricerank[$s_rank][$n_sizeclass]; //DEBUG
            } else {
                $this->quote['error'] = MODULE_SHIPPING_YUUPACK_TEXT_OUT_OF_AREA . '(' . $s_key .')';
            }
        } else {
            $this->quote['error'] = MODULE_SHIPPING_YUUPACK_TEXT_ILLEGAL_ZONE
             . '(' . $this->OriginZone . '=>' . $this->DestZone . ')';
        }

        return $this->quote;
    }
    // ѥåθĿꤹ
    // : ʤĿ򡢰۾ʤ-1֤
    function GetBoxes($weight, $limit) {
        $max_boxes = min(100, $this->Items);
        $num = 0;
        do {
            if ( ++$num > $max_boxes ) {
              return -1;
            }
            // ;͵Ψ
            $room_ratio = ($this->Mode == 'volume' && $num < $this->Items)
                          ? max(1.0,MODULE_SHIPPING_YUUPACK_ROOM) : 1.0;
        } while ($weight / $num * $room_ratio > $limit);

        return $num;
    }
}
?>