/* -*- C++ -*- Time-stamp: <99/05/18 16:58:15 tfuruka1> 
 *
 * MIMẼfR[h֌W̏sBA낭RFCǂłȂ̂ŁA
 * ۏ؂͂ȂB */
#include <windows.h>
#include <string.h>
/* ------------------------------------------------------------------
 * uCodeŎw肳ꂽEUCR[hSHIFT-JISR[h֕ϊBJISR[
 * hSHIFT-JIS֕ϊ鎖\łB̂ȂEUCJISR[h
 * 1oCgڂ2oCgڂ̍ŏʃrbg𗧂ĂĂ邾Ȃ̂ŁA
 * rbg𗎂ƂJISR[hɂȂĂ܂łB̕ϊ֐ł
 * ɂ̃rbg𗎂ƂĂ邽߁AEUCłJISłoBA
 * ɌpJ^Ji͕ϊoȂB
 * *-----------------------------------------------------------------*/
static SHORT
EUCToSjis(USHORT uCode)
{
    USHORT uByte1, uByte2;

    uCode &= 0x7f7f;                            // JISłEUCłv

    uByte1 = (uCode >> 8) & 0xff;
    uByte2 = uCode & 0xff;

    if (uByte1 & 1) 
        uByte2 += (0x40 - 0x21);
    else
        uByte2 += (0x9e - 0x21);

    if (0x7f <= uByte2) {
        uByte2++;
    }
    uByte1 -= 0x21;
    uByte1 >>= 1;
    uByte1 += 0x81;
    if (0xa0 <= uByte1) {
        uByte1 += 0x40;
    }
    return uByte1 * 256 + uByte2;
}

/* ------------------------------------------------------------------
 * Base64̈ꕶɑΉR[hԋpBBase64̕64ił
 * Aꂼ̕ȉ̃R[hɑΉĂB
 *
 *          _  0 1 2 3 4 5 6 7
 *          __________________
 *          000 | A B C D E F G H
 *          010 | I J K L M N O P
 *          020 | Q R S T U V W X
 *          030 | Y Z a b c d e f
 *          040 | g h i j k l m n
 *          050 | o p q r s t u v
 *          060 | w x y z 0 1 2 3
 *          070 | 4 5 6 7 8 9 + /
 * *-----------------------------------------------------------------*/
static int
GetBase64Code(int c)
{
    char cBase64[] = {"ABCDEFGHIJKLMNOPQRSTUVWXYZ"
                      "abcdefghijklmnopqrstuvwxyz"
                      "0123456789+/"};
    int i;
    for (i = 0; i < 64; i++) {
        if (c == cBase64[i]) {
            return i;
        }
    }
    return 0;
}
/* ------------------------------------------------------------------
 * lpszInOutŎw肳ꂽBase64DecodeBBase6434oC
 * gƂĕ\ĂB]āAK񒷂4̔{ɂȂBEncode
 * 6̔{ɂȂȂꍇ '=' t4̔{ɂȂ悤
 * ȂĂB
 *
 * +---------------+---------------+---------------+
 * |7 6 5 4 3 2 1 0|7 6 5 4 3 2 1 0|7 6 5 4 3 2 1 0|
 * +---------------+---------------+---------------+
 *            |           |           |           |
 *            |           |           |           +---------------+
 *            +---+       +-------+   +-----------+               |
 *                |               |               |               |
 * +---------------+---------------+---------------+---------------+
 * |* * 5 4 3 2 1 0|* * 5 4 3 2 1 0|* * 5 4 3 2 1 0|* * 5 4 3 2 1 0|
 * +---------------+---------------+---------------+---------------+
 *
 * *-----------------------------------------------------------------*/
static PUCHAR
DecodeBase64(PUCHAR lpszInOut)
{
    PUCHAR szFrom, szTo;
    ULONG uDecode = 0;
    int nOffset = 0;

    szFrom = szTo = lpszInOut;

    while (*szFrom) {
        if ('\r' == *szFrom || '\n' == *szFrom || ' ' == *szFrom) {
            szFrom++;                           // ͖̕
            continue;
        }

        uDecode = (uDecode << 6) + GetBase64Code(*szFrom);
        nOffset++;
        szFrom++;
        if (3 < nOffset) {
            *szTo++ = (UCHAR)((uDecode >> 16) & 0xff);
            *szTo++ = (UCHAR)((uDecode >> 8) & 0xff);
            *szTo++ = (UCHAR)((uDecode >> 0) & 0xff);
            nOffset = 0;
            uDecode = 0;
        }
    }
    *szTo = '\0';
    return lpszInOut;
}
/* ------------------------------------------------------------------
 * ISO-2022-JPȂ镶SHIFT-JIS֕ϊBUS-ASCII
 * ܂ĂĂ\łBȂ݂ɑɌpJ^Ji
 * ISO-2022-JPɂ݂͑Ȃ̂ŁAϊ͍sĂȂB
 * *-----------------------------------------------------------------*/
PUCHAR
Iso2022jpToSjis(
    PUCHAR szInOut,                             // o̓obt@
    int cESC                                    // GXP[v ʏ'B'
    )
{
    BOOL bKanji = FALSE;
    PUCHAR szFrom, szTo;
    UCHAR szKI[] = "\033$x", szKO[] = "\033(x";
    USHORT uCode;

    szFrom = szTo = szInOut;
    *(szKI + 2) = cESC;
    while (*szFrom) {
        if ('\033' == *szFrom) {
            if (0 == memcmp(szKI, szFrom, 3)) {
                bKanji = TRUE;
                szFrom += 3;
                continue;
            }
            if (0 == memcmp(szKO, szFrom, 2)) { // KO̍Ō͌̕Ȃ
                bKanji = FALSE;
                szFrom += 3;
                continue;
            }
            *szTo++ = *szFrom++;
            continue;
        }
        if (!bKanji) {
            *szTo++ = *szFrom++;
            continue;
        }
        uCode = *szFrom * 256 + *(szFrom + 1);
        uCode = EUCToSjis(uCode);
        *szTo = (uCode >> 8) & 0xff;
        *(szTo + 1) = uCode & 0xff;
        szTo += 2;
        szFrom += 2;
    }
    *szTo = '\0';
    return szInOut;
}
/* -------------------------------------------------------------------
 * MHSwb_MIMESHIFT-JIS֕ϊBϊ̃ASY͈ȉ
 * ʂłBႦ
 *
 *     Subject: =?ISO-2022-JP?B?GyRCNEE7ehsoSg==?=
 *              ^ ^           ^ <--- Base64 --->^
 *              | |           |                 |
 *              | |           |                 +- END
 *              | |           +------------------- ESC CHAR
 *              | +------------------------------- CODE
 *              +--------------------------------- START
 *
 * Ƃ񂪑݂ꍇAMIME̊Jnł '=?' A
 * ݂ꍇ͏Ił '?='AʒuoĒuB
 * āAZbgISO-2022-JP or iso-2022-jpł鎖mFB
 * ȊO̕Zbg̏ꍇ͕ϊsȂBɃGXP[u𒲂ׂB
 * Base64̕Base64ŃfR[hāAISO-2022-JPSHIFT-JIS֕
 * B̎US-ASCIIISO-2022-JP̃GXP[vZp[^ESC
 * CHARgpB
 * *------------------------------------------------------------------*/
#define MSTARTL "=?ISO-2022-JP?"
#define MSTARTS "=?iso-2022-jp?"
#define MEND    "?="
PUCHAR
DecodeMHS(PUCHAR lpszInOut)
{
    PUCHAR lpMStart, lpMEnd, p;
    int cESC;

    // ŏɌps𔻒fāAs̘AKvȏꍇ͌B
    p = lpszInOut;
    while ((lpMStart = strstr(p, "\r\n")) ||
           (lpMStart = strstr(p, "\n"))) {
        p = lpMStart;
        p += ('\r' == *lpMStart ? 2 : 1);
        if (' ' != *p && '\t' != *p) {
            continue;                           // pswł͂ȂB
        }
        for (; ' ' == *p || '\t' == *p; p++);   // 擪̃Xy[Xǂݔ΂
        if (0 == strncmp("=?", p, 2)) {         // psw
            strcpy(lpMStart, p);                // A
        }
    }

    p = lpszInOut;
    while ((lpMStart = strstr(p, MSTARTL)) ||
           (lpMStart = strstr(p, MSTARTS))) {
        cESC = *(lpMStart + strlen(MSTARTS));
        p = lpMStart + strlen(MSTARTS) + 2;
        if (!(lpMEnd = strstr(p, MEND))) {
            continue;                           // MIMEᔽ
        }
        *lpMEnd = '\0';
        lpMEnd += strlen(MEND);

        Iso2022jpToSjis(DecodeBase64(p), cESC);
        strcpy(lpMStart, p);
        strcat(lpMStart, lpMEnd);
        p = lpMStart;
    }
    // {͋KᔽłAJISMHSwb_ɏĂꍇɂ
    // ĂΉB
    Iso2022jpToSjis(lpszInOut, 'B');

    return lpszInOut;
}

#if 0 // 1ɂƒP̂œ삷B
/* -------------------------------------------------------------------
 * ȉ̓fobOp̃C֐łB
 * *------------------------------------------------------------------*/
void main(void)
{
    char szBuf[1024] = "GyRCNEE7ehsoSg==";

    printf("IN >>%s\n", szBuf);
    printf("OUT>>%s\n", Iso2022jpToSjis(DecodeBase64(szBuf), 'B'));

    strcpy(szBuf, "=?ISO-2022-JP?B?GyRCNDQ7dhsoSg==?=ABC\n"
           " =?ISO-2022-JP?B?GyRCNDQ7dhsoSg==?=ABC\n"
           "  =?ISO-2022-JP?B?GyRCNDYkOBsoSg==?=123\n"
           "   =?ISO-2022-JP?B?GyRCNEE7ehsoSg==?=kanji\n"
           "    =?ISO-2022-JP?B?GyRCNDQ7dhsoSg==?=ABC\n"
           "     =?ISO-2022-JP?B?GyRCNDQ7dhsoSg==?=ABC\n"
           "\t\t\t=?ISO-2022-JP?B?GyRCNDYkOBsoSg==?=123\n"
           " =?ISO-2022-JP?B?GyRCNEE7ehsoSg==?=kanji\n"
           " =?ISO-2022-JP?B?GyRCNDQ7dhsoSg==?=ABC\n"
           " =?ISO-2022-JP?B?GyRCNDQ7dhsoSg==?=ABC\n"
           " =?ISO-2022-JP?B?GyRCNDYkOBsoSg==?=123\n"
           "     =?ISO-2022-JP?B?GyRCNEE7ehsoSg==?=kanji");
    printf("IN >>%s\n", szBuf);
    printf("OUT>>%s\n", DecodeMHS(szBuf));

    while (fgets(szBuf, 1024, stdin)) {
        printf("%s", DecodeMHS(szBuf));
    }
}
#endif
