/* -*- mode: c++; coding: sjis-dos; -*-
 * Time-stamp: <2003-03-15 23:13:55 tfuruka1>
 *
 * uak2pŝ悤Ȃ́v̈vr[
 *
 * $Id: prev.c,v 1.4 2003/03/15 14:41:51 tfuruka1 Exp $
 * $Log: prev.c,v $
 * Revision 1.4  2003/03/15 14:41:51  tfuruka1
 *  ݒs悤ɂB
 *
 * Revision 1.3  2001/12/23 10:07:54  tfuruka1
 * vr[p̃rbg}bvmNɕύXBv^̉𑜓xƉʂ̉
 * x̔䗦Ńvr[sĂAǂĂ덷ׁAv
 * r[̉𑜓xv^̉𑜓xƓɂAƁArbg}b
 * v̍쐬ŁAsׁAmNrbg}bvɕύXB
 *
 * Revision 1.2  2001/12/18 04:07:51  tfuruka1
 * vr[EChËʒuƃTCYLĂ悤ɏC
 *
 * Revision 1.1  2001/12/14 17:09:38  tfuruka1
 * Initial revision
 */
// (replace-regexp "/\\*\\(.+\\)\\*/" "//\\1")
// (replace-regexp "[ \t]+$" "")

#include "ak2prs.h"
#include "ak2pr.h"

PPREVIEW_INFO pPrevInfo = NULL;

static VOID
DoPaint(HWND hWnd)
{
    HDC hDC;
    PAINTSTRUCT ps;
    RECT rc;
    int wd, ht;
    int x, y;

    GetClientRect(hWnd, &rc);

    // NCAg̈̉Z(NAg̈Ɏ܂悤ɃAXyNg
    // ێ܂܃TCYvZ)
    wd = rc.right;
    ht = pPrevInfo->ht * wd / pPrevInfo->wd;
    if (ht > rc.bottom) {
        ht = rc.bottom;
        wd = pPrevInfo->wd * ht / pPrevInfo->ht;
    }

    // NCAg̈̒ɔzu
    x = rc.right / 2 - wd / 2;
    y = rc.bottom / 2 - ht / 2;
    
    hDC = BeginPaint(hWnd, &ps);

    if (wd != rc.right) {
        // ̗]hԂ
        rc.left = x + wd;
        FillRect(hDC, &rc, GetStockObject(DKGRAY_BRUSH));

        rc.left = 0;
        rc.right = x;
        FillRect(hDC, &rc, GetStockObject(DKGRAY_BRUSH));
    }
    else if (ht != rc.bottom) {
        // c̗]hԂ
        rc.top = y + ht;
        FillRect(hDC, &rc, GetStockObject(DKGRAY_BRUSH));

        rc.top = 0;
        rc.bottom = y;
        FillRect(hDC, &rc, GetStockObject(DKGRAY_BRUSH));
    }

    // vr[C[W]
    if (!StretchBlt(hDC, x, y, wd, ht,
                    pPrevInfo->hDC, 0, 0, pPrevInfo->wd, pPrevInfo->ht,
                    SRCCOPY)) {
        int nErr = GetLastError();
        DbgPrint(NULL, 'E', "DoPaint: %s",
                 GetLastErrorMessage("StretchBlt()", nErr));
    }

    EndPaint(hWnd, &ps);
}

static BOOL CALLBACK
DialogProc(
    HWND hWnd,
    UINT uMsg,
    WPARAM wParam,
    LPARAM lParam
    )
{
    int nDPIW, nDPIH;                           // ʂ̉𑜓x
    int wd, ht;                                 // ƍ
    HDC hDC, hDCMem;                            // foCXReLXg
    HBITMAP hBitMap;                            // rbg}bv

    switch (uMsg) {
    case WM_INITDIALOG:
        SetWindowText(hWnd, PV_CAPTION);
        SetWindowPos(hWnd, HWND_TOPMOST,
                     pPrevInfo->rc.left, pPrevInfo->rc.top,
                     pPrevInfo->rc.right - pPrevInfo->rc.left,
                     pPrevInfo->rc.bottom - pPrevInfo->rc.top, 0);
        // ʂ̉𑜓x𓾂
        nDPIW = GetDeviceCaps(pPrevInfo->hDC, LOGPIXELSX);
        nDPIH = GetDeviceCaps(pPrevInfo->hDC, LOGPIXELSY);

        // ʂƉ𑜓xɌƍ𓾂
        wd = pPrevInfo->wd * nDPIW / pPrevInfo->dpiW;
        ht = pPrevInfo->ht * nDPIH / pPrevInfo->dpiH;

        // rbg}bv쐬
        if (!(hBitMap = CreateBitmap(wd, ht, 1, 1, NULL))) {
            MessageBox(g_MailBox.hWnd, 
                       GetLastErrorMessage("CreateBitmap" __FILE__,
                                           GetLastError()),
                       SV_CAPTION, MB_ERROR);
            return FALSE;
        }
        hDC = GetDC(hWnd);
        hDCMem = CreateCompatibleDC(hDC);
        ReleaseDC(hWnd, hDC);

        SelectObject(hDCMem, hBitMap);

        // vr[C[W]
        if (!StretchBlt(hDCMem, 0, 0, wd, ht,
                    pPrevInfo->hDC, 0, 0, pPrevInfo->wd, pPrevInfo->ht,
                    SRCCOPY)) {
            int nErr = GetLastError();
            DbgPrint(NULL, 'E', "InitDialog: %s",
                     GetLastErrorMessage("StretchBlt()", nErr));
        }

        // vr[Ɋi[Ărbg}bvjAV
        // i[
        DeleteDC(pPrevInfo->hDC);
        DeleteObject(pPrevInfo->hBitmap);

        pPrevInfo->hDC = hDCMem;
        pPrevInfo->hBitmap = hBitMap;
        pPrevInfo->wd = wd;
        pPrevInfo->ht = ht;

        InvalidateRect(hWnd, NULL, FALSE);
        return TRUE;
    case WM_SYSCOMMAND:
        switch (wParam) {
        case SC_CLOSE:
            EndDialog(hWnd, FALSE);
            return TRUE;
        default:
            return FALSE;
        }
        return FALSE;
    case WM_COMMAND:
        switch (LOWORD(wParam)) {
        case IDM_SETUP:
            SetupPrtStyle(hWnd, &g_MailBox.PrtInfo);
            // Break͈̂Ӑ}Ă܂
        case IDOK:
            EndDialog(hWnd, TRUE);
            pPrevInfo->status
                = (IDOK == LOWORD(wParam)) ? PVI_PRINT : PVI_SETUP;

            GetWindowRect(hWnd, &pPrevInfo->rc);
            SetPreViewPos(&pPrevInfo->rc);
            return TRUE;
        case IDCANCEL:
            EndDialog(hWnd, FALSE);
            pPrevInfo->status = PVI_CANCEL;
            return TRUE;
        default:
            return FALSE;
        }
        return FALSE;
    case WM_SIZE:
        InvalidateRect(hWnd, NULL, FALSE);
        return TRUE;
    case WM_PAINT:
        DoPaint(hWnd);
        return TRUE;
    }
    return FALSE;
}

BOOL
PrintPreview(
    HWND hWnd,                                  // EChEnh
    PPREVIEW_INFO ppi                           // vr[
    )
{
    int nRet;
    HINSTANCE hInst = GetWindowInstance(hWnd);

    pPrevInfo = ppi;
    nRet = DialogBox(hInst, MAKEINTRESOURCE(IDD_PREV), hWnd, DialogProc);
    if (-1 == nRet) {
        DbgPrint(NULL, 'E', "%s", GetLastErrorMessage("DialogBox",
                                                      GetLastError()));
        return FALSE;
    }
    return nRet;
}

/*--------------------------------------------------------------------
 * hDCPrinterŎw肳ĂfoCXReLXgAvr[p̃f
 * oCXReLXg쐬Bvr[p̃foCXReLXg
 * gpIɔjKv܂B܂AfoCXReLX
 * gLĂrbg}bvjKv܂B(́A
 * ̉𑜓x𓾂āAv^̉𑜓xƂ̔䗦Arbg}bṽTCY
 * vZĂ܂A̕@ƂǂĂ덷Ă܂Av
 * r[ƈňقȂʂ邽߁Á݂Av^̉
 * xƓ𑜓xŃmNrbg}bv쐬悤ɂĂ܂B
 * ƁAǁEEE)
 * *-------------------------------------------------------------------*/
HDC WINAPI
MakePreviewInfo(HWND hWnd,                      // EChEnh
                HDC hDCPrinter,                 // v^DC
                PPREVIEW_INFO pPrev             // vr[
    )
{
    HDC hDC = GetDC(hWnd);
    int nDPIWPrt, nDPIHPrt;                     // v^̉𑜓x
    int nWidthPrt, nHeightPrt;                  // v^̃TCY
    int nPaperMarginW, nPaperMarginH;           // sGA

    if (!hDC) {
        DbgPrint(NULL, 'E', "%s",
                 GetLastErrorMessage("GetDC" __FILE__,
                                     GetLastError()));
        return NULL;
    }

    if (!(pPrev->hDC = CreateCompatibleDC(hDC))) {
        DbgPrint(NULL, 'E', "%s",
                 GetLastErrorMessage("CreateCompatibleDC" __FILE__,
                                     GetLastError()));
        ReleaseDC(hWnd, hDC);
        return NULL;
    }

    // v^̉𑜓x𓾂
    nDPIWPrt = GetDeviceCaps(hDCPrinter, LOGPIXELSX);
    nDPIHPrt = GetDeviceCaps(hDCPrinter, LOGPIXELSY);

    // ʂ̉𑜓x𓾂
#if 0
    pPrev->dpiW = GetDeviceCaps(pPrev->hDC, LOGPIXELSX);
    pPrev->dpiH = GetDeviceCaps(pPrev->hDC, LOGPIXELSY);
#else
    pPrev->dpiW = nDPIWPrt;
    pPrev->dpiH = nDPIHPrt;
#endif
    // v^̗pTCY𓾂
    nWidthPrt = GetDeviceCaps(hDCPrinter, PHYSICALWIDTH);
    nHeightPrt = GetDeviceCaps(hDCPrinter, PHYSICALHEIGHT);

    // ʂ̃TCY肷
#if 0
    pPrev->wd = nWidthPrt * pPrev->dpiW / nDPIWPrt;
    pPrev->ht = nHeightPrt * pPrev->dpiH / nDPIHPrt;
#else
    pPrev->wd = nWidthPrt;
    pPrev->ht = nHeightPrt;
#endif
    // v^̈sGA𓾂
    nPaperMarginW = GetDeviceCaps(hDCPrinter, PHYSICALOFFSETX);
    nPaperMarginH = GetDeviceCaps(hDCPrinter, PHYSICALOFFSETY);

    // ʂ̈sGAݒ肷
#if 0
    pPrev->xoff = nPaperMarginW * pPrev->dpiW / nDPIWPrt;
    pPrev->yoff = nPaperMarginH * pPrev->dpiH / nDPIHPrt;
#else
    pPrev->xoff = nPaperMarginW;
    pPrev->yoff = nPaperMarginH;
#endif

    // rbg}bv쐬
    if (!(pPrev->hBitmap
          = /*CreateCompatibleBitmap(hDC, pPrev->wd, pPrev->ht)*/
          CreateBitmap(pPrev->wd, pPrev->ht, 1, 1, NULL))) {
        MessageBox(g_MailBox.hWnd, 
                   GetLastErrorMessage("CreateCompatibleBitmap" __FILE__,
                                       GetLastError()),
                   SV_CAPTION, MB_ERROR);
        ReleaseDC(hWnd, hDC);
        return NULL;
    }
    SelectObject(pPrev->hDC, pPrev->hBitmap);

    DbgPrint(NULL, 'D', "vr[pfoCXReLXg쐬܂\n"
             "     |   Printer   |   Preview\n"
             "DPI  | %5dx%5d | %5dx%5d\n"
             "SIZE | %5dx%5d | %5dx%5d",
             nDPIWPrt, nDPIHPrt, pPrev->dpiW, pPrev->dpiH,
             nWidthPrt, nHeightPrt, pPrev->wd, pPrev->ht);

    ReleaseDC(hWnd, hDC);

    return pPrev->hDC;
}
