#! /bin/bash

# Variables
PKGS=(fontforge ttf-inconsolata)
MIGP="http://sourceforge.jp/frs/redir.php?m=jaist&f=%2Fmix-mplus-ipa%2F53389%2Fmigu-1m-20111002.zip"
RICP=http://save.sys.t.u-tokyo.ac.jp/~yusa/fonts/ricty/Ricty-3.1.3.tar.gz


# Install required packages 
#   listed in PKGS with apt.
for PKG in ${PKGS[@]} ; do
  echo Installing $PKG with apt.
  sudo apt-get install $PKG
done


# Make user's font dir
#   (if not exists) and
#   move there.
cd ~
if ! [ -e .fonts ] ; then
  mkdir -p .fonts
fi
cd .fonts

# Installing migu-1m font
wget $MIGP -O migu-1m.zip
unzip migu-1m.zip
fc-cache -fv

# Installing Ricty font
wget $RICP -O Ricty.tgz
tar zxvf Ricty.tgz
Ricty/ricty_generator.sh auto

