package tainavi;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;

/*
 * <P>ツールバーの検索キーワードのリストを保持するクラスです。
 * @since 3.22.18β+1.10
 *
 * @see ListedColumnInfoList
 */

public class SearchWordList {
	/*
	 * 定数
	 */
	private final String filename = "env"+File.separator+"searchwords.xml";

	private final String MSGID = "[検索ワード] ";
	private final String ERRID = "[ERROR]"+MSGID;
	private final int maxwords = 128;

	/*
	 * 部品
	 */
	private ArrayList<SearchWordItem> list = new ArrayList<SearchWordItem>();

	public int size() { return list.size(); }

	public boolean add(String s){
		for (SearchWordItem item : list){
			if (item.getKeyword().equals(s)){
				item.notifyUse();
				sortList();
				return true;
			}
		}

		SearchWordItem item = new SearchWordItem(s);
		list.add(item);
		sortList();

		while (list.size() > maxwords){
			list.remove(list.size()-1);
		}

		return true;
	}

	/**
	 * 検索ワードの一覧を返す
	 */
	public ArrayList<SearchWordItem> getWordList() {
		return list;
	}

	public void clear() {
		list.clear();
	}

	public boolean load() {
		if ( ! new File(filename).exists() ) {
			System.err.println(ERRID+"設定が読み込めませんでした、検索ワードは無効です: "+filename);
			return false;
		}

		@SuppressWarnings("unchecked")
		ArrayList<SearchWordItem> tlist = (ArrayList<SearchWordItem>) CommonUtils.readXML(filename);
		if ( tlist == null ) {
			System.err.println(ERRID+"設定の読み込みに失敗しました、検索ワードは無効です: "+filename);
			return false;
		}

		System.out.println(MSGID+"設定を読み込みました: "+filename);

		list = tlist;
		return true;
	}

	public boolean save() {
		if ( ! CommonUtils.writeXML(filename, list) ) {
			System.err.println(ERRID+"設定の保存に失敗しました： "+filename);
			return false;
		}

		return true;
	}

	private class SearchWordComparator implements Comparator<SearchWordItem>{
		@Override
		public int compare(SearchWordItem p1, SearchWordItem p2) {
			int rc = p2.getCount() - p1.getCount();
			if (rc != 0)
				return (rc > 0) ? 1 : -1;

			return p2.getLastUsedTime().compareTo(p1.getLastUsedTime());
		}
	}

	protected void sortList(){
		list.sort(new SearchWordComparator());
	}
}
