#共通関数
package Util;

use strict;
use warnings;
use utf8;
use Unicode::GCString;
use Encode;
use Archive::Zip qw( :ERROR_CODES :CONSTANTS );

##############################
#hash操作

#hashの値をキーでソートした配列を返す
sub sort_hash{
    my ($hash,%arg_opt) = @_;
    
    my %opt = (dir => "asc");
    %opt = (%opt,%arg_opt);
    
    #ソートキーの配列をソート
    my @keys=keys %$hash;
    if ($opt{dir} eq "asc"){
        @keys=sort @keys;
    }else{
        @keys =reverse sort @keys;
    }
    
    #出力
    my @data=();
    for (my $i=0;$i<scalar(@keys);$i++){
        push @data,$hash->{$keys[$i]};
    }
    
    return \@data;
}


#hashを比較したhohを作成
sub compare_hash{
    my ($hash1,$hash2) = @_;
    
    my @keys1 = keys %$hash1;
    my @keys2 = keys %$hash2;
    my @keys = (@keys1,@keys2);
    my $keys = Util::uniq_array(\@keys);
    @keys = sort @$keys;
    my %hoh=();
    for my $key (@keys) {
        my $val1 = defined($hash1->{$key}) ? $hash1->{$key}:"-";
        my $val2 = defined($hash2->{$key}) ? $hash2->{$key}:"-";

        my %hash=();
        $hash{key}  = $key;
        $hash{val1} = $val1;
        $hash{val2} = $val2;
        $hash{compare} = get_compare_str($val1,$val2);
        $hoh{$key} = \%hash;
    }
    return \%hoh;
}

sub get_compare_str{
    my ($val1,$val2) = @_;
    
    if ($val1 eq "-" && $val2 eq "-") {
        return "-";
    }
    
    #数字として比較
    if ($val1 =~ /^\d+$/ && $val2 eq "-") {
        return $val1;
    }
    
    if ($val2 =~ /^\d+$/ && $val1 eq "-") {
        return -$val2;
    }
    
    if (($val1 =~ /^\d+$/) && ($val2 =~ /^\d+$/)){
        my $diff= $val1 - $val2;
        if ($diff>0) {
            $diff = "+".$diff;
        }
        return $diff;
    }
    
    #文字列として比較
    if ($val1 eq "-" || $val2 eq "-") {
        return "-";
    }
    
    if (($val1 cmp $val2) == 0){
        return "=";
    }elsif (($val1 cmp $val2) >0){
        return ">";
    }else{
        return "<";
    }
}

##############################
#配列操作

=pod
配列が同じか

sort
    1:順番も考慮する
    0:順番は考慮しない（ソートしてから比較）
=cut
sub is_same_array{
    my ($a,$b,%arg_opt) = @_;
    
    my %opt = (sort => 0);
    %opt = (%opt,%arg_opt);
    
    my $bRet=0;
    if ($opt{sort} eq 1) {
        my @aa = sort @$a;
        my @bb = sort @$b;
        
        $a=\@aa;
        $b=\@bb;
    }
    
    if (join('',@$a) eq join('',@$b)){
        $bRet = 1;
    }
    return $bRet;
}


#配列(リスト)から重複を取り除く
sub uniq_array{
    my $array = shift;
    my %hash  = ();

    foreach my $value ( @$array ){
        $hash{$value} = 1;
    }

    my @ret = keys %hash;
    return \@ret;
}

#配列(リスト)から重複を取り除く
#廃止予定
sub uniqArray{
    my $array = shift;
    my %hash  = ();

    foreach my $value ( @$array ){
        $hash{$value} = 1;
    }

    return(
        keys %hash
    );
}

#配列から重複する要素を抽出
sub get_duplicated_value{
    my $array = shift;
    my %hash  = ();
    my @arr_ret =();

    foreach my $value ( @$array ){
        if (defined($hash{$value})){
            push @arr_ret,$value;
        }else{
            $hash{$value} = 1;
        }
    }

    return \@arr_ret;
}

=pod
配列に指定値が存在するかチェック
excat
    1:  完全一致
    0:  部分一致(配列中の文字列に指定値が含まれればOKを返す)
=cut
sub is_exist_in_array{
    my ($arr,$arg_val,%arg_opt) = @_;
    
    my %opt = (exact => 1);
    %opt = (%opt,%arg_opt);
    
    my $bRet=0;
    foreach my $val (@$arr) {
        if ($val eq $arg_val) {
            $bRet = 1;
            last;
        }
        if (($opt{exact}==0) && ($val =~ /$arg_val/)){
            $bRet = 1;
            last;
        }
    }
    return $bRet;
}

=pod
配列をフィルター
arr
    配列
filters
    フィルタ正規表現の配列
reverse
    =>0:  フィルタに合致する場合出力
    =>1:  フィルタに合致しない場合出力
=cut
sub filter_array{
    my ($arr,$filters,%arg_opt) = @_;
    
    my %opt = (reverse => 0);
    %opt = (%opt,%arg_opt);    
    
    my @ret=();
    for my $item (@$arr){
        my $bOut=is_match_patterns($item,$filters);
        if ($opt{reverse} ==0) {
            $bOut=!$bOut;
        }
        if ($bOut==1) {
            push @ret,$item;
        }
    }
    
    return \@ret;
}

##############################
#文字列操作

=head1 is_match_patterns
対象文字列が正規表現のパターンの配列に一致するか
str
    対象文字列
patterns
    正規表現の配列
=cut
sub is_match_patterns{
    my ($str,$patterns)=@_;
    for my $pattern (@$patterns){
       if ($str =~ /$pattern/){
           return 1;
       } 
    }
    return 0;
}

=head1 get_paddedstr4unicode
対象unicode文字列を、指定桁数までpaddingした文字列を取得
=cut
sub get_paddedstr4unicode{
    my ($str,$width) = @_;
    my $gcs  = Unicode::GCString->new($str);
    return $str . " " x ($width - $gcs->columns);
}

=head1 get_width4unicode
対象unicode文字列の、printfの桁数指定用文字数を取得
使用例
printf "%-*s",$str,Util::get_width4unicode($str,10)


=cut
sub get_width4unicode{
    my ($str,$width) = @_;
    my $gcs  = Unicode::GCString->new($str);
    return $gcs->chars + ($width - $gcs->columns);
}

=head1
整数かどうかを返す
=cut
sub is_integer{
    my $str=shift;
    my $bRet = 0;
    if ($str =~ /^\-?\d+$/){
        $bRet =1;
    }
    return $bRet;
}

=head1
文字列の前後の空白文字を除く
=cut
sub trim {
	my $val = shift;
	$val =~ s/^\s*(.*?)\s*$/$1/;
	return $val;
}

##############################
#ファイル関連

=pod
更新日時でソートしたファイル名リストを取得

file_pattern
    globに渡すファイル名のパターン
arg_opt{dir}
    asc:昇順
=cut
sub get_file_list_sorted{
    my ($file_pattern,%arg_opt) = @_;
    
    my @files = glob($file_pattern);
    my %hash=();
    for my $file (@files) {
        my $key=(stat $file)[9];
        $hash{$key}=$file;
    }
    return sort_hash(\%hash,%arg_opt);
}

##############################
#ZIP操作

sub unzip{
    my $fileName = shift;
    
    #オブジェクトを作成
    my $zip = Archive::Zip->new();
    
    #ファイルの読み込みに失敗したら強制終了
    die 'read error' unless $zip->read($fileName) == AZ_OK;
    
    #ファイルの数はnumberofMembersで取得できます
    #print "Extracting " . $zip->numberOfMembers($fileName) . " files from $fileName\n";
    
    #ファイルの一覧を取得
    my @members = $zip->members();
    
    foreach (@members) {
          #ファイル名はfileNameにて取得できます。
          #print $_->fileName() . "\n";
          my $name = $_->fileName();
          
          #ファイルをアーカイブから取り出すにはextractMemberもしくはextractMemberWithoutPathsを使用します。
          $zip->extractMember($name);
    }
}
1;
