=pod
CSVを結合

=cut

use strict;
use warnings;

use Getopt::Long;
use IO::File;
use Data::Dumper;
use utf8;
use Encode;

use Util;
use CSVAsHash;

binmode STDOUT => ":encoding(sjis)";
binmode STDERR => ":encoding(sjis)";

my %opts=(in_header=>1);
&main_proc();

sub main_proc{
    my $res=GetOptions(\%opts,'in_file=s','add_file_pattern=s','out_file=s','key_col_names=s','in_header=i','in_tab','log_file=s');
    print decode("cp932",Dumper(\%opts));
    
    my @key_col_names = split(/,/,decode('cp932',$opts{key_col_names}));
    
    my @files = glob $opts{add_file_pattern};
    if (scalar(@files) == 0) {
        printf "%s:ファイルが見つかりません\n",$opts{add_file_pattern};
        exit;
    }
    
    if (defined($opts{in_file})&&(-f $opts{in_file})) {
        unshift @files,$opts{in_file};
    }
    
    my $in_sep_char;
    if (defined($opts{in_tab})) {
        $in_sep_char="\t";
    }else{
        $in_sep_char=",";
    }
    
    my $csv_in = CSVAsHash->new(csv_header=>$opts{in_header},csv_sep_char=>$in_sep_char);
    
    my %hoh_out=();
    my %dup=();     #$key=>[ファイル名の配列]
    my $first_header;
    for (my $i=0;$i<scalar(@files);$i++) {
        my $aoh_in=$csv_in->csv2aoh($files[$i]);
        if ($i==0){
        	$first_header=$csv_in->col_names();
        }else{
        	if (Util::is_same_array($csv_in->col_names(),$first_header,sort=>1)!=1) {
        		die("$files[$i]:ヘッダが一致しません\n");
        	}
        }
        printf "%s:%d件入力\n",decode("cp932",$files[$i]),scalar(@$aoh_in);
        my $lno=1;
        for my $line (@$aoh_in){
            my $key=CSVAsHash::concate_cols($line,\@key_col_names);
            if (defined($dup{$key})){
                my $arr=$dup{$key};
                push @$arr,sprintf("%s:%d行目",decode('cp932',$files[$i]),$lno+$opts{in_header});
            }else{
                $dup{$key}=[sprintf("%s:%d行目",decode('cp932',$files[$i]),$lno+$opts{in_header})];
            }
            $hoh_out{$key}=$line;
            $lno++;
        }
    }

    my @aoh_out=values(%hoh_out);
    $csv_in->aoh2csv(\@aoh_out,$opts{out_file});
    printf "%s:%d件出力しました\n",decode("cp932",$opts{out_file}),scalar(@aoh_out);

    my $f_log;
    if (defined($opts{log_file})){
        $f_log=IO::File->new($opts{log_file},"w");
    }
    
    #重複キー出力
    while (my ($key, $arr) = each(%dup)){
        if (scalar(@$arr)>1){
            for my $file (@$arr){
                my $str=sprintf("重複:%s:%s\n",$key,$file);

                if (defined($opts{log_file})){
                    $f_log->print($str);
                }else{
                    print $str;                    
                }
            }
        }
        
    }
}
