﻿#HashLikeArrayテスト

use strict;
use warnings;

use Text::CSV_XS;
use IO::File;
use Data::Dumper;
use Getopt::Long;
use utf8;
use Encode;
use Test::More;

use HashLikeArray;

binmode STDOUT => ":encoding(sjis)";

plan (tests=>1); 
my $g_enc=find_encoding('cp932');
my $csv = Text::CSV_XS->new ({ 
        binary      => 1
});

my $fi= IO::File->new( 'test.txt', "r")||die $!;

my $header =1;
my $cnt =0;
my $cols_in = HashLikeArray->new('cp932');
while (my $col = $csv->getline ($fi)) {
    if ($header!=1){
        $cols_in->cols($col);
        my $code=$cols_in->get_col_data("商品コード");
        my $name=$cols_in->get_col_data("商品名");
        #printf "%s,%s\n",$code,$name;
        if ($code eq 'a1'){
			is($name,'あああ',$g_enc->encode('a1=>あああ'));
		}
        $cnt++;
    } else {
        #ヘッダ処理
        $cols_in->get_col_tbl($col);
        $header =0;
    }
}
$fi->close();
