using System;
using System.Collections.Generic;
using System.Text;

using Eyes.Properties;

using System.Diagnostics;

using System.Net.NetworkInformation;
using System.Net;

// TODO:public classȂ̂ɁA
// private ȃo[Ă̂H

namespace Eyes
{
    public class NetInfo
    {
        public NetInfo(string name, IPAddress address)
        {
            Name = name;
            IPAddress = address;
        }

        private string name;

        public string Name
        {
            get { return name; }
            set { name = value; }
        }

        private IPAddress ipaddress;

        public IPAddress IPAddress
        {
            get { return ipaddress; }
            set { ipaddress = value; }
        }
    }

    class NetAdapter
    {
        public static List<NetInfo> GetNetInfo()
        {
            //ׂẴlbg[NC^[tFCX擾
            NetworkInterface[] nis = NetworkInterface.GetAllNetworkInterfaces();
            List<NetInfo> infos = new List<NetInfo>();
            foreach (NetworkInterface ni in nis)
            {
                //\AAhX擾
                IPInterfaceProperties ipips = ni.GetIPProperties();
                if (ipips != null)
                {
                    if (ipips.UnicastAddresses.Count == 0)
                    {   // IPAhX擾łȂA_v^͍폜
                        continue;
                    }
                    // 0Ԗڂ𖳏Ɏgp
                    infos.Add(new NetInfo(ni.Name, ipips.UnicastAddresses[0].Address));
                }
            }
            return infos;
        }

        public static int GetSelectedIndex(List<NetInfo> infos)
        {
            int index = 0;
            string adapter = Settings.Default.Adapter;

            if (adapter == "")
            {   // ݒ̏ꍇ0ɐݒ
                Settings.Default.Adapter = infos[0].Name;
                return 0;
            }

            foreach (NetInfo info in infos)
            {
                if (info.Name.Equals(adapter))
                {
                    return index;
                }
                index++;
            }
            // w肵̂Ȃꍇ0ɐݒ
            Settings.Default.Adapter = infos[0].Name;
            return 0;
        }

        public static IPAddress GetAddress()
        {
            List<NetInfo> infos = GetNetInfo();
            int index = GetSelectedIndex(infos);

            return infos[index].IPAddress;
        }
    }
}
