using System;
using System.Collections.Generic;
using System.Text;

using Eyes.Properties;

namespace Eyes
{
    public class ContactMember : Member
    {
        private bool notify = Settings.Default.Notify;
        /// <summary>
        /// 通知をするかしないかのフラグ
        /// </summary>
        public bool Notify
        {
            get { return notify; }
            set { notify = value; }
        }

        /// <summary>
        /// メンバー情報をコピーする
        /// </summary>
        /// <param name="member">情報のコピー先</param>
        public void CopyFrom(Member member)
        {
            this.Address = member.Address;
            this.Machine = member.Machine;
            this.Memo = member.Memo;
            this.Name = member.Name;
            this.NickName = member.NickName;
            this.Status = member.Status;
        }
    }
}
