using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.Diagnostics;

using System.Net.Sockets;
using System.IO;

namespace LocalMessenger
{
    public partial class Messenger : Form
    {
        // `bĝ̃o[Xg
        private List<ContactMember> memberList = new List<ContactMember>();

        /// <summary>
        /// ڑ̃o[Ƀo[Xg𓾂
        /// </summary>
        /// <returns>o[Xg</returns>
        public List<Member> GetMemberList()
        {
            List<Member> list = new List<Member>();

            foreach (ContactMember contact in memberList)
                list.Add(contact.Member);

            return list;
        }

        /// <summary>
        /// ڑ̃o[Ƀo[܂܂Ă邩ׂ
        /// </summary>
        /// <param name="member">o[</param>
        /// <returns>o[܂܂Ă true</returns>
        public bool Contains(Member member)
        {
            // [U[ IP AhXv瓯Ƃ݂Ȃ
            foreach (ContactMember contact in memberList)
                if ((contact.Member.Name == member.Name) &&
                    (contact.Member.Address == member.Address))
                    return true;

            return false;
        }

        /// <summary>
        /// o[Xgv邩݂Ȃ
        /// </summary>
        /// <param name="list">o[Xg</param>
        public bool Equals(List<Member> list)
        {
            if (memberList.Count != list.Count)
                return false;

            foreach (Member member in list)
                if (Contains(member) == false)
                    return false;

            return true;
        }

        /// <summary>
        /// `bg̃o[𓾂
        /// </summary>
        /// <param name="username">o[</param>
        /// <param name="address">o[ IP AhX</param>
        private ContactMember GetMember(string username, string address)
        {
            // [U[ IP AhXv炻̃o[Ԃ
            foreach (ContactMember contact in memberList)
                if (contact.Member.Name.Equals(username) &&
                    contact.Member.Address.Equals(address))
                    return contact;

            return null;
        }

        /// <summary>
        /// o[ǉ
        /// </summary>
        /// <param name="member">ǉ郁o[</param>
        /// <param name="client">TCP NCAg</param>
        /// <param name="key">AES Í</param>
        /// <param name="iv">AES xNg</param>
        public void Add(Member member, TcpClient client, byte[] key, byte[] iv)
        {
            ContactMember contact = GetMember(member.Name, member.Address);

            if (contact == null)
            {   // }l[W烁o[̃CX^XŃ`bgCX^X
                contact = new ContactMember(manager, member);

                // ̃}l[W̃Xgɑ肪ȂڑȂ
                if (contact.Member == null)
                    return;

                // bZ[W󂯎̃nho^
                contact.received += new ReceivedHandler(ReceiveMessage);
                memberList.Add(contact);
            }

            // ɐڑĂꍇ̓Xg[ւ邱ƂɂȂ
//            contact.Start(client, key, iv);
            listMember();   // o[Xg̕\XV
        }

        /// <summary>
        /// eLXgǉ
        /// </summary>
        /// <param name="text">ǉeLXg</param>
        public void AppendText(string text)
        {
            messageLog.AppendText(text);
            messageLog.ScrollToCaret();
        }

        /// <summary>
        /// 肩烁bZ[WM̏
        /// </summary>
        /// <param name="message">MbZ[W</param>
        private void ReceiveMessage(Message message)
        {
            if (message == null)
                return;

            if (this.messageLog.InvokeRequired)
            {
                ReceivedHandler d = new ReceivedHandler(ReceiveMessage);
                this.Invoke(d, new object[] { message });
            }
            else
            {
                // bZW[EBhEŏĂ^Cgo[_ł
                if (this.WindowState == FormWindowState.Minimized)
                    this.BlinkTitleBar();

                messageLog.AppendText(message.Member.NickName + "F\r\n");
                messageLog.Select(messageLog.TextLength, 0);

                if (message.Rtf != "")
                    messageLog.SelectedRtf = message.Rtf;

                if (message.Files.Count > 0)
                {
                    messageLog.AppendText("  -- ȉ̃t@CMł܂B--  ");
                    AddFileButton(message.Member, message.Files);
                }

                messageLog.ScrollToCaret();
            }
        }

        /// <summary>
        /// ɃbZ[W𑗐M鎞̏
        /// </summary>
        /// <param name="SendMessage">M郁bZ[W</param>
        private void SendMessage(List<string> files)
        {
            if (messageBox.Text != "" || files.Count > 0)
            {
                Message message = new Message();
                message.Member = manager.User;
                message.Files = files;

                if (messageBox.Text != "")
                {
                    message.Rtf = messageBox.Rtf;
                    messageLog.AppendText(message.Member.NickName + "F\r\n");
                    messageLog.Select(messageLog.TextLength,    0);

                    if (messageBox.Text != "")
                        messageLog.SelectedRtf = message.Rtf;
                }

                foreach (ContactMember member in memberList)
                    try
                    {
                        Packet packet = new Packet();
                        packet.Tag = Packet.Content.MESSAGE;
                        packet.Data = message;

                        member.Send(packet);
                        if (files.Count > 0)
                        {
                            messageLog.AppendText("  -- ȉ̃t@CMo^܂B--\r\n");
                            int num = 0;
                            foreach (string file in files)
                            {
                                if (num++ > 0)
                                    messageLog.AppendText(", ");

                                FileInfo info = new FileInfo(file);
                                messageLog.AppendText(info.Name);
                            }
                            messageLog.AppendText("\r\n");
                        }
                    }
                    catch (ObjectDisposedException e)
                    {
                        Debug.WriteLine(e);
                        messageLog.AppendText("  -- bZ[WMł܂łB--\r\n");
                    }
                    catch (NullReferenceException e)
                    {
                        Debug.WriteLine(e);
                        messageLog.AppendText("  -- bZ[WMł܂łB--\r\n");
                    }

                messageLog.ScrollToCaret();
                messageBox.Clear();
            }
        }
    }
}
